#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <assert.h>
#define READ 0
#define WRITE 1

//process a
main(){
    int pid, test, fds1[2], fds2[2];

    if(pipe(fds1) < 0 || pipe(fds2) < 0){
        perror("Could not pipe!");
        exit(1);
    }

    //process b
    switch(fork()){

        case 0:
            //process c
            switch(pid = fork()){
                case 0:
                    test = close(fds1[READ]); assert(test == 0);
                    test = close(fds1[WRITE]); assert(test == 0);
                    test = close(fds2[READ]); assert(test == 0);
                    test = close(fds2[WRITE]); assert(test == 0);
                    sleep(3600);
                    exit(0);
                    break;
                case -1:
                    perror("could not fork! (c)");
                    exit(1);
            }
            test = close(WRITE); assert(test == 0);
            test = dup(fds1[WRITE]); assert(test == WRITE);

            test = close(fds1[READ]); assert(test == 0);
            test = close(fds1[WRITE]); assert(test == 0);
            test = close(fds2[READ]); assert(test == 0);
            test = close(fds2[WRITE]); assert(test == 0);

            sleep(3);
            write(WRITE, &pid, sizeof(int));
            wait(0);
            sleep(6);
            exit(0);
            break;

        case -1:
            perror("could not fork! (b)");
            exit(1);
    }

    //process a, b and c
    system("ps -o pid,ppid,pgid,sess,comm");
    sleep(2);

    //process k
    switch(fork()){
        case 0:
            test = close(READ); assert(test == 0);
            test = dup(fds1[READ]); assert(test == READ);
            test = close(WRITE); assert(test == 0);
            test = dup(fds2[WRITE]); assert(test == WRITE);

            test = close(fds1[READ]); assert(test == 0);
            test = close(fds1[WRITE]); assert(test == 0);
            test = close(fds2[READ]); assert(test == 0);
            test = close(fds2[WRITE]); assert(test == 0);

            sleep(1);
            execlp("./killer", "./killer", (char*) NULL);
            perror("Process k failed execlp()");
            exit(1);
            break;

        case -1:
            perror("could not fork! (k)");
            exit(1);
    }

    //process a, b, c and k
    system("ps -o pid,ppid,pgid,sess,comm");
    sleep(1);

    read(fds2[READ], &pid, sizeof(int));

    //process a, b and k
    system("ps -o pid,ppid,pgid,sess,comm");

    test = close(fds1[READ]); assert(test == 0);
    test = close(fds1[WRITE]); assert(test == 0);
    test = close(fds2[READ]); assert(test == 0);
    test = close(fds2[WRITE]); assert(test == 0);

    //wait for k
    wait(0);

    //process a and b
    system("ps -o pid,ppid,pgid,sess,comm");
    //wait for b
    wait(0);

    printf("Process k has killed pid: %d", pid);

    return 0;
}
