#include <stdio.h>
#include <stdlib.h>

main(int argc, char *argv[])
{
    int i,n,d;
    pid_t pid;

    if(argc!=3){    //Kontrollera så att det är rätt mängd argument.
        printf("Invalid use of parameters. ./uppg1 <nr of children> <child to exit first>.\n");
        exit(1);
    }

    n = atoi(argv[1]);
    d = atoi(argv[2]);

    if(n<1){
        printf("Invalid use of parameters. <nr of children> has to be greater than 0.\n");
        exit(1);
    }
    if(d<1){
        printf("Invalid use of parameters. <child to exit first> has to be greater than 0\n");
        exit(1);
    }
    if(d>n){
        printf("Invalid use of parameters. <child to exit first> can't greater than <nr of children>\n");
        exit(1);
    }

    pid = fork();
    if(pid==-1){
        fprintf(stderr,"Fork failed.\n");
        exit(1);
    }else if(pid==0){
        for(i=0;i<n;i++){
            switch(fork()){
                case -1:    //Error
                    fprintf(stderr,"Fork failed.\n");
                    exit(1);
                    break;
                case 0:     //Child
                    if(i==(d-1)){
                        sleep(2);
                    }else{
                        sleep(4);
                    }
                    exit(0);
                    break;
                default:    //Parent
                    break;
            }
        }
        exit(0);
    }
    wait(0);
    sleep(1);
    system("echo ========================== 1 second passed");
    system("ps -e -o pid,ppid,pgid,sess,comm | grep uppg1");
    sleep(2);
    system("echo ========================== 3 seconds passed");
    system("ps -e -o pid,ppid,pgid,sess,comm | grep uppg1");
    sleep(2);
    system("echo ========================== 5 seconds passed");
    system("ps -e -o pid,ppid,pgid,sess,comm | grep uppg1");
}
