#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <assert.h>

#define READ 0
#define WRITE 1

int main() {

	int fds1[2], fds2[2], test, a;
  	pipe(fds1); pipe(fds2);

  	if(!fork())
  	{
		pid_t cpid;    	
		if(!(cpid = fork()))
    	{
			test = close(fds1[READ]); assert(test == 0);
			test = close(fds1[WRITE]); assert(test == 0);
			test = close(fds2[READ]); assert(test == 0);
			test = close(fds2[WRITE]); assert(test == 0);		      		
			sleep(2);
			exit(0);
    	}
		
		test = close(fds1[READ]); assert(test == 0);
		test = close(fds2[READ]); assert(test == 0);
		test = close(fds2[WRITE]); assert(test == 0);
		
		sleep(1);		
		
		write(fds1[WRITE],&cpid,sizeof(int));
		
		test = close(fds1[WRITE]); assert(test == 0);
		
		wait(0);
		sleep(1);
		exit(0);
	}
	
	system("ps -o pid,ppid,comm");
	
	if(!fork()) {
		test = close(READ); assert(test == 0);
    	test = dup(fds1[READ]); assert(test == READ);
		test = close(WRITE); assert(test == 0);
    	test = dup(fds2[WRITE]); assert(test == WRITE);
		
		test = close(fds1[READ]); assert(test == 0);
		test = close(fds1[WRITE]); assert(test == 0);
		test = close(fds2[READ]); assert(test == 0);
		test = close(fds2[WRITE]); assert(test == 0);
		
		sleep(1);		
			
		execlp("./killer","./killer",NULL);
    	fprintf(stderr,"execlp did not work\n");
    	exit(1);	
	}
	
	system("ps -o pid,ppid,comm");	
	
	sleep(1);

	test = close(fds1[READ]); assert(test == 0);
	system("ps -o pid,ppid,comm");
	test = close(fds1[WRITE]); assert(test == 0);
	test = close(fds2[WRITE]); assert(test == 0);		
	
	wait(0);

	while(read(fds2[READ], &a, sizeof(int)))
		printf("Child killed: %d\n", a);	
	
	test = close(fds2[READ]); assert(test == 0);

	system("ps -o pid,ppid,comm");
	wait(0);	

	return 0;
}
