#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <assert.h>

#define READ 0
#define WRITE 1

void main()
{

    int fds1[2], fds2[2], pid, kpid;
    char pidstr[30];

    pipe(fds1);
    pipe(fds2);

    if(!fork())
    {
        int test;

        test = close(WRITE); assert(test==0);
        test = dup(fds1[WRITE]); assert(test==1);
        test = close(fds1[READ]); assert(test==0);
        test = close(fds2[READ]); assert(test==0);
        test = close(fds2[WRITE]); assert(test==0);
        sleep(1);

        int pid = fork();
        switch(pid)
        {
        case -1:
            fprintf(stderr,"Fork failed.\n");
            exit(1);

        case 0:
            sleep(4);

        default:
            write(fds1[WRITE],&pid,sizeof(int));
            sleep(4);
            wait(0);
            sleep(4);
            exit(0);
        }
    }

    sleep(1);
    system("ps -o pid,ppid,comm");

    sleep(2);
    kpid = fork();
    if(!kpid)
    {
        int test;
        test = close(READ); assert(test==0);
        test = dup(fds1[READ]); assert(test==0);
        test = close(fds1[READ]); assert(test==0);
        test = close(fds1[WRITE]); assert(test==0);
        test = close(WRITE); assert(test==0);
        test = dup(fds2[WRITE]); assert(test==1);
        test = close(fds2[WRITE]); assert(test==0);
        test = close(fds2[READ]); assert(test==0);
        sleep(1);
        execlp("./killer", "./killer", NULL);
        fprintf(stderr,"execlp did not work\n");
        exit(1);

    }



    system("ps -o pid,ppid,comm");
    sleep(2);
    system("ps -o pid,ppid,comm");
    sleep(1);

    read(fds2[READ],&pid,sizeof(int));
    printf("Child killed %d\n", pid);

    sprintf(pidstr,"kill %d",kpid);
    system(pidstr);

    wait(0);

    sleep(1);
    system("ps -o pid,ppid,comm");
    wait(0);

}
