#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>

int main()
{
	int p1[2]; // Pipe for B - K
	if (pipe(p1))
	{
		printf("Could not create pipe #1\n");
		return -1;
	}
	
	if (!fork())
	{
		// Process B
		int cID;

		if (!(cID = fork()))
		{
			// Process C
			sleep(100); // Sleep untill killed
		}
		
		close(p1[0]);
		sleep(3);

		if (!write(p1[1], &cID, sizeof(int)))
		{
			printf("Could not write cID\n");
			return -1;
		}
		wait(0); // Wait for child C
		sleep(2);	
		close(p1[1]);
		sleep(1); // Sleep to survive untill last checkpoint
		return 0;
	}
	
	// Process A
	int p2[2]; // Pipe for K - A
	if (pipe(p2))
	{
		printf("Could not create pipe #2\n");
		return -1;
	}
	
	sleep(1);
	system("ps -o pid,ppid,comm"); // Checkpoint 1
	close(p1[1]);

	if (!fork())
	{
		// Process K
		close(0);
		close(1);
		dup(p1[0]); // Dup p1 to stdin
		dup(p2[1]); // Dup p2 to stdout
		close(p1[0]);  // Close all remaining pipes
		close(p2[0]);
		close(p2[1]);
		execlp("./k", "./k", NULL);
		printf("Could not start ./k\n");
		return -1;
	}
	
	close(p1[0]);
	close(p2[1]);
	
	sleep(1); // Wait for next checkpoint
	system("ps -o pid,ppid,comm");
	sleep(1); // Child C should be dead before this is done
	system("ps -o pid,ppid,comm");

	int kID;
	if (!read(p2[0], &kID, sizeof(int)))
	{
		printf("Could not read from pipe #2 in A\n");
		return -1;
	}
	printf("Child killed: %d\n", kID);
	close(p1[0]);
	close(p2[0]); // Close p2 to exit K
	wait(0);
	system("ps -o pid,ppid,comm");
}
