#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <assert.h>

main()
{
    int pid;
    int fds1[2];
    int fds2[2];
    pipe(fds1);
    pipe(fds2);
    int test;

    pid=fork();
    if(pid==0)
    {//b

        test=close(fds2[0]);            assert(test==0);
        test=close(fds2[1]);            assert(test==0);

        test=close(1);                  assert(test==0);
        write(fds1[1], &pid, sizeof(int));
        close(fds1[0]);                 assert(test==0);
        close(fds1[1]);                 assert(test==0);

        pid=fork();
        if(pid==0)
        {
            //c
            sleep(2);
            exit(0);
        }

        sleep(4);
        exit(0);
    }
    system("ps -o pid,ppid,comm");        //X1

    pid=fork();
    if(pid==0)
    {//k
        sleep(2);
        while(read(fds2[0], &pid, sizeof(int)))

        test=dup(fds2[0]);          assert(test==0);
        test=close(fds2[0]);        assert(test==0);
        test=close(fds2[0]);        assert(test==0);
        execlp("./killer", "./killer", NULL);
        fprintf(stderr,"execlp did not work\n");

        exit(1);
    }

    test=close(fds1[0]);            assert(test==0);
    test=close(fds1[1]);            assert(test==0);
    test=close(fds2[0]);            assert(test==0);
    test=close(fds2[1]);            assert(test==0);

    system("ps -o pid,ppid,comm");        //X2
    wait(0);
    system("ps -o pid,ppid,comm");
    wait(0);
    system("ps -o pid,ppid,comm");
    wait(0);

}
