#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

main(int argc, char *argv[])
{
    //Proccess A
    int fds1[2], fds2[2],result;
    pid_t pidc;
    if(pipe(fds1)<0){
        perror("pipe");
        exit(EXIT_FAILURE);
    }
    if(pipe(fds2)<0){
        perror("pipe");
        exit(EXIT_FAILURE);
    }

    switch(fork()){
        case -1://Error
            fprintf(stderr,"Fork failed.\n");
            exit(1);
        case 0: //Proccess B
            switch(pidc=fork()){
                case -1: //Error
                    fprintf(stderr,"Fork failed.\n");
                    exit(1);
                case 0: //Proccess C
                    close(fds1[0]);/* Close the read end of the pipe fds1. */
                    close(fds1[1]);/* Close the write end of the pipe fds1. */
                    close(fds2[0]);/* Close the read end of the pipe fds2. */
                    close(fds2[1]);/* Close the write end of the pipe fds2. */
                    while(1){
                        sleep(100);
                    }
                    break;
                default://Proccess B
                    close(fds1[0]);/* Close the read end of the pipe fds1. */
                    close(fds1[1]);/* Close the write end of the pipe fds1. */
                    close(fds2[0]);/* Close the read end of the pipe fds2. */
                    if(write(fds2[1],&pidc,sizeof(int))==-1){/* Write pidc to the write end of the pipe fds2. */
                        perror("write");
                        exit(EXIT_FAILURE);
                    }
                    close(fds2[1]);/* Close the write end of the pipe fds2. */
                    wait(0);//Wait for proccess C
                    sleep(3);
                    exit(0);//Exit proccess B
                    break;
            }
            break;
        default://Proccess A
            break;
    }
    sleep(1);
    system("ps -o pid,ppid,comm");  //Process A , B , C
    //Proccess A
    switch(fork()){
        case -1://Error
            fprintf(stderr,"Fork failed.\n");
            exit(1);
        case 0: //Proccess 2K
            sleep(2);
            close(fds1[0]);/* Close the read end of the pipe fds1. */
            close(fds2[1]);/* Close the write end of the pipe fds2. */
            if(dup2 (fds2[0], STDIN_FILENO)==-1){/* Connect the read end of the pipe fds2 to standard input. */
                perror("dup2");
                exit(EXIT_FAILURE);
            }
            if(dup2 (fds1[1], STDOUT_FILENO)==-1){/* Connect the write end of the pipe fds1 to standard output. */
                perror("dup2");
                exit(EXIT_FAILURE);
            }
            execlp("./killer","./killer",NULL);//KOLLA RETURNVÄRDE
            fprintf(stderr,"Execlp failed.\n");
            exit(1);//Exit proccess K
            break;
        default://Proccess A
            sleep(1);
            system("ps -o pid,ppid,comm");  //Process A , B , C , K
            sleep(1);
            system("ps -o pid,ppid,comm");  //Process A , B , K
            break;
    }




    close(fds1[1]);
    close(fds2[0]);
    close(fds2[1]);
    while(read(fds1[0],&result,sizeof(int))){

        if(result>0){

                 printf("Child killed:%d\n",result);
        }

    }
    close(fds1[0]);

    //system("ps -o pid,ppid,comm");  //Process A , B , K

    //Process A
    wait(0);//wait for proccess
    sleep(1);
    system("ps -o pid,ppid,comm");  //Process A , B
    wait(0);//B and K
}
