#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <unistd.h>
#include <assert.h>

#define READ 0
#define WRITE 1

void printsystem(int i){
    printf("--utskrift: %d \n",i);  /** La till så jag såg vilken del i koden det var som skrev. För annars var det svårt att hitta utskrift 1,2,3 o 4 **/
    system("ps -o pid,ppid,comm");
}

int main(void){
    int fds1[2], fds2[2], test, a;  /** fds1 mellan b-k, fds2 mellan k-a **/
    pipe(fds1); pipe(fds2);
    pid_t pid;


    switch(fork()){ /** FORK A-B **/
    case -1:
        perror("fork failed");
        exit(1);
    case 0: /** Här börjar B **/

        test = close(fds1[READ]);assert(test==0);
        test = close(fds2[READ]);assert(test==0);
        test = close(fds2[WRITE]);assert(test==0);

        pid = fork();   /** FORK B-C **/
        switch(pid){
        case -1:
            perror("fork failed");
            exit(1);
        case 0: /** Här börjar C **/
            test = close(fds1[WRITE]);assert(test==0); //nu är alla pipes stängda i C
            for(;;){    /** jag låter bara C göra någonting hela tiden **/
                sleep(1);
            }
            break;
        default:
            break;
        }

        /** utskrift 1 **/
        printsystem(1);

        write(fds1[WRITE],&pid,sizeof(int));
        test = close(fds1[WRITE]);assert(test==0); //nu är alla pipes stängda i B.

        sleep(2);
        wait(0);

        /** utskrift 4 **/
        printsystem(4);

        exit(0);
        break;
    default:    //a igen..
        break;
    }

    sleep(2);

    switch(fork()){
    case -1:
        perror("fork failed");
        exit(1);
    case 0: /** Här börjar K **/

        /** utskrift 2 **/
        printsystem(2);
        //omdirigera stdin till fds1
        test = close(READ);assert(test==0);
        test = dup(fds1[READ]);assert(test==0);
        test = close(fds1[READ]);assert(test==0);
        test = close(fds1[WRITE]);assert(test==0);

        //omdirigera stdout till fds2
        test = close(WRITE);assert(test==0);
        test = dup(fds2[WRITE]);assert(test==1);    /** OBS! dup returnerar den nya fildeskriptorn! därför 1 och inte 0 som alla andra assert **/
        test = close(fds2[WRITE]);assert(test==0);
        test = close(fds2[READ]);assert(test==0);
        //nu är alla pipes stängda i K

        execlp("./killer", "./killer", NULL);
        fprintf(stderr,"execlp did not work\n");
        exit(1);

        break;
    default:
        break;
    }

    test = close(fds1[READ]);assert(test==0);
    test = close(fds1[WRITE]);assert(test==0);
    test = close(fds2[WRITE]);assert(test==0);

    read(fds2[READ],&a,sizeof(int));
    printf("Child killed: %d\n",a);

    /** utskrift 3 Vet tyvärr inte hur jag ska perfektera utskriften för C och kill blir <defunct> men i print 4 syns de inte längre.
    Det är ända stället jag lyckas visa att K bytt processbild till kill **/
    printsystem(3);

    test = close(fds2[READ]);assert(test==0);
    // nu är alla pipes stängda i A

    wait(0);
    wait(0);
}
