#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <assert.h>

#define READ 0
#define WRITE 1

int main()
{
    int fds1[2], fds2[2], test=0;
    pid_t pid;

    if(pipe(fds1)==-1)
    {
        printf("error pipe1");
    }

    if(pipe(fds2)==-1)
    {
        printf("error pipe2");
    }


    if(!fork()) // b
    {

        if(!fork()) // c
        {
            sleep(1);
            exit(0);
        }
        pid=getpid();

        test = close(READ); assert(test==0);
        test = dup2(fds1[WRITE],WRITE); assert(test==1);
        test = close(fds1[READ]); assert(test==0);
        write(WRITE,&pid,sizeof(int));
        test = close(WRITE); assert(test==0);


        sleep(3);

        wait(0);
        exit(0);
    }

    if(!fork()) // k
    {
        test = close(WRITE); assert(test==0);
        test = dup2(fds1[READ],READ); assert(test==0);
        test = close(fds1[WRITE]); assert(test==0);
        test = close(READ); assert(test==0);

        sleep(1);

        test = close(READ); assert(test==0);
        test = dup2(fds2[WRITE],WRITE); assert(test==1);
        test = close(fds2[READ]); assert(test==0);
        test = close(WRITE); assert(test==0);

        execlp("./killer.c","./killer.c","NULL");

    }

    test = close(WRITE); assert(test==0);
    test = dup2(fds2[READ],READ); assert(test==0);
    read(READ,&pid,sizeof(int));
    test = close(fds2[WRITE]); assert(test==0);
    test = close(READ); assert(test==0);

    system("ps -o pid, ppid,comm");
    sleep(1);
    system("ps -o pid, ppid,comm");
    sleep(1);
    system("ps -o pid, ppid,comm");
    sleep(1);
    system("ps -o pid, ppid,comm");


    wait(0);
    wait(0);


    return 0;
}
