#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>

int main() {
    int test, p1[2], p2[2], pidOfC;
    pipe(p1);
    pipe(p2);
    if (fork() == 0) { // b
        if ((pidOfC = fork()) == 0) { // c
            // c is not using any pipe
            test = close(p1[0]); assert(test == 0);
            test = close(p1[1]); assert(test == 0);
            test = close(p2[0]); assert(test == 0);
            test = close(p2[1]); assert(test == 0);
            sleep(8); // only sleep k kill
            perror("c survived\n");
            exit(1);
            //exit(0);
        }
        test = close(p1[0]); assert(test == 0);
        test = close(p2[0]); assert(test == 0);
        test = close(p2[1]); assert(test == 0);
        sleep(3);
        write(p1[1], &pidOfC, sizeof(int));

        wait(0); //cleanup c

        sleep(2);
        test = close(p1[1]); assert(test == 0); // killer should exit
        sleep(1);
        exit(0);

    }
    sleep(1); // 3 proc
    system("ps -o pid,ppid,comm");

    if (fork() == 0) { // k
        test = close(p1[1]); assert(test == 0);
        test = close(p2[0]); assert(test == 0);
        test = close(0); assert(test == 0);
        test = dup(p1[0]); assert(test == 0);
        test = close(p1[0]); assert(test == 0);
        test = close(1); assert(test == 0);
        test = dup(p2[1]); assert(test == 1);
        test = close(p2[1]); assert(test == 0);
        sleep(2);
        execlp("./killer", "./killer", NULL);
        fprintf(stderr, "Could not exec ./killer\n");
        exit(1);
    }
    sleep(1); // 4 proc
    system("ps -o pid,ppid,comm");

    sleep(2); // 3 proc k
    system("ps -o pid,ppid,comm");
    test = close(p1[0]); assert(test == 0);
    test = close(p1[1]); assert(test == 0);
    test = close(p2[1]); assert(test == 0);
    read(p2[0], &pidOfC, sizeof(int));
    printf("Child killed: %d\n", pidOfC);
    sleep(1);
    wait(0); // clean killer
    system("ps -o pid,ppid,comm");
    wait(0);
    test = close(p2[0]); assert(test == 0);


    return 0;
}

