



/* Programmet hamnar i deadlock då det uppstår cirkulär väntan 
för att få tillgång till gemensamt delade resurser.
   Om man använder en recursive mutex (som ökar värdet med ett 
på en variabel när den låser och minskar med ett när den släpper låset)
   och pthread_mutex_trylock() istället för vanliga lock så ska det 
fungera utan låsning då den funktionen
   kollar om någon annan tråd är låst på resursen innan den försöker 
låsa på den och så minskar man variabeln med ett när tråden är färdig med den
   så att andra tråden får möjlighet att låsa på den. */



#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

pthread_mutex_t resource[5];
char res_str[] = "00000";

int pick(){return rand()%5;}
int pick2(){return rand()%2+1;}

void* t1 (void * p) {
  int r1, r2;
  while(1) {
    r1=pick(); r2=pick();
    sleep(pick2());
    pthread_mutex_trylock(&resource[r1]);
    res_str[r1]='1';
    pthread_mutex_trylock(&resource[r2]);
    res_str[r2]='1';
    sleep(pick2());
    res_str[r1]='0';
    res_str[r2]='0';
    pthread_mutex_unlock(&resource[r1]);
    pthread_mutex_unlock(&resource[r2]);
  }
}

void* t2 (void * p) {
  int r1, r2;
  while(1) {
    r1=pick(); r2=pick();
    sleep(pick2());
    pthread_mutex_trylock(&resource[r1]);
    res_str[r1]='2';
    pthread_mutex_trylock(&resource[r2]);
    res_str[r2]='2';
    sleep(pick2());
    res_str[r1]='0';
    res_str[r2]='0';
    pthread_mutex_unlock(&resource[r1]);
    pthread_mutex_unlock(&resource[r2]);
  }
}

main() {
  int i=0,n;
  pthread_t id1, id2;
  pthread_create(&id1,NULL,&t1,NULL);
  pthread_create(&id2,NULL,&t2,NULL);
  while(i++<30)
  {
    sleep(1);
    printf("%2d: %s\n", i, res_str);
  }
}

