<?php

namespace Chat\Controller;

use Chat\Util\Startup;
use Chat\Integration\ConversationStore;
use Chat\Model\Entry;

/**
 * This is the application's controller. All calls from the view pass through here.
 */
class Controller {
    private const CONTR_KEY = Startup::CONST_PREFIX . 'controller';

    private $nickName;
    private $convStore;
    
    public function __construct() {
        $this->convStore = new ConversationStore();
    }

    /**
     * Returns the controller stored in the session, if there is such a controller. If there is
     * not, a new instance is created.
     * 
     * @return \Chat\Controller\Controller The current controller, as described above. 
     */
    public static function getController() {
        if (!isset($_SESSION[self::CONTR_KEY])) {
            return new Controller();
        }
        return unserialize($_SESSION[self::CONTR_KEY]);
    }
    
    /**
     * Appends a new entry to the current conversation.
     * 
     * @param \Chat\Model\Entry $entry The entry to append.
     */
    public function addEntry(Entry $entry) {
        $this->convStore->addEntry($entry);
    }

    /**
     * Delete the entry with the specified timestamp.
     * 
     * @param int $timestamp The timestamp of the entry that shall be deleted.
     */
    public function deleteEntry(int $timestamp) {
        $this->convStore->deleteEntry($timestamp);
    }

    /**
     * @return array The entire conversation.
     */
    public function getConversation() {
        return $this->convStore->getConversation();
    }

    /**
     * Stores the user's nick name.
     * @param string $nickName The user's nick name.
     */
    public function setNickName(string $nickName) {
        $this->nickName = $nickName;
    }

    /**
     * @return string The user's nick name.
     */
    public function getNickName() {
        return $this->nickName;
    }

    /**
     * Serializes this object and stores it in the session array.
     */
    public function __destruct() {
        $_SESSION[self::CONTR_KEY] = serialize($this);
    }

}
