import numpy as np
import math
import matplotlib.pyplot as plt
import imageio

# Wheight matrix for jpeg
W = np.array(np.mat('16 11 10 16 24 40 51 61; 12 12 14 19 26 58 60 55; 14 13 16 24 40 57 69 56; 14 17 22 29 51 87 80 62; 18 22 37 56 68 109 103 77; 24 35 55 64 81 104 113 92; 49 64 78 87 103 121 120 101; 72 92 95 98 112 100 103 99'), dtype=float)

# Function: dct_basis for calculating dct-base-vector matrix
# Input: m (positive integer) - Basis vector length
# Output: T (mxm matrix) - DCT basis matrix, each column: basis vector
def dct_basis(m):
    # Initialize a matrix 

    # Fill it up ackording to equations in instructions

# Function: jpeg_encode. Encode image using block-by-block DCT-coefficients
# Input: I (nxm matrix) - Input image
# Output: C (nxm matrix) - DCT coefficient matrix
# Parameters: bs - blocksize
def jpeg_encode(I):
    # Initialize a matrix the same size as I
    
    # Divide into submatrices and apply matrix operations
    bs = 8
    for p in range(0, math.floor(I.shape[0] / bs)):
        for q in range(0, math.floor(I.shape[1] / bs)):
            Isub = I[p*bs: (p+1)*bs, q*bs: (q+1)*bs]
            Isub = Isub - 128*np.ones( (bs, bs))
            #Put matrix operation under this line

            ###
            C[p*bs: (p+1)*bs, q*bs: (q+1)*bs] = Csub
    return C
# Input: C (nxm matrix) - DCT transform matrix
# Output: I (nxm matrix) - Output image
def jpeg_decode(C):
    # Initialize a matrix the same size as C
    
    # Divide into submatrices and iteratively apply matrix operations
    bs = 8
    for p in range(0, math.floor(C.shape[0] / bs)):
        for q in range(0, math.floor(C.shape[1] / bs)):
            Csub = C[p*bs: (p+1)*bs, q*bs: (q+1)*bs]
            #Put matrix operation under this line
            
            ###
            Isub = Isub + 128*np.ones((bs, bs))
            I[p*bs: (p+1)*bs, q*bs: (q+1)*bs] = Isub
    return I
