import numpy as np
import scipy.fftpack as fft
import scipy.io.wavfile as wav
import matplotlib.pyplot as plt
import math



# Function: dtmf_decode
# Input:  X  - numpy array of audio samples
#         fs - sampling frequency
# Output: decoded charachter ('1','2','3','4','5','6','7','8','9','*','#','A','B','C','D' or '')

def dtmf_decode(X,fs):
    
    # array of the 8 standardized DTMF frequencies
    dtmf_freqs = np.array((697,770,852,941,1209,1336,1477,1633))

    # compute power spectrum of X

    # find power for each of of the DTMF frequencies

    # check all combinations of the 4 low and 4 high frequencies

    # return string

    
# Function: dtmf_segment
# Input: E - numpy array representing the smoothed energy contour of the audio signal
# Output: two numpy arrays - start and stop - containing start and stop sample of each segment

def dtmf_segment(E):
    T = E>0.5*np.max(E)
    T = np.hstack((0,T,0))
    dT = np.hstack((np.diff(T),0))
    start = np.nonzero(dT == 1)
    stop = np.nonzero(dT == -1)
    return start[0],stop[0]

# Function: dtmf_block_analysis
# Input: X - numpy array of audio samples
#        blocksize - length of block in samples


def dtmf_block_analysis(X, blocklen):

    # step through the signal one block at a time
    for i in range(0,int(math.floor(X.shape[0]/blocklen))):
        Xblock = X[i*blocklen:(i+1)*blocklen]

        # do stuff with Xblock below
