function S = dtmf_segment(E)
% dtmf_segment - threshold-based segmentation of energy signal
% 
% input:
%   E (Nx1 column vector) - Input energy signal
% output: 
%   S (Mx2 matrix)        - Segmentation matrix - each row contains "start"
%                           and "end" times (in samples) for a segment


% Calculate vector T that is a threshold of the energy vector E: 
%   T will be 1 whenerver E is above half of
%   maximum energy, 0 otherwise...

T=E>.5*(max(E));

% add a zero at the beginning and end of T so we dont miss initial and final jumps
T=[0;T;0]; 

% calculate a diff (derivate) vector of T. Will be 1 when T jumps
%   from 0 to 1, and -1 when T jumps from 1 to 0, and 0 when T is constant.

dT=[diff(T); 0];

% find only those places where dT is  1 and -1

S = [find(dT==1) find(dT==-1)];
