
open Utils
open Ustring.Op
open Printf
open Ast
open Msg

exception Runtime_error of Msg.message


let evalprog filename =   
  let fs1 = open_in filename in
  let tablength = 8 in
  begin try 
    Lexer.init (us filename) tablength;
    fs1 |> Ustring.lexing_from_channel
        |> Parser.main Lexer.main 
	|> ignore (* Here is the term to use! *)
  with
    | Lexer.Lex_error m -> fprintf stderr "%s\n" 
	(Ustring.to_utf8 (Msg.message2str m))
    | Runtime_error m -> fprintf stderr "%s\n" 
	(Ustring.to_utf8 (Msg.message2str m))
    | Parsing.Parse_error -> fprintf stderr "%s\n" 
	(Ustring.to_utf8 (Msg.message2str (Lexer.parse_error_message())))  
  end; close_in fs1

let menu() =
    printf "Usage: lambda <file> <options>\n";
    printf "Options:\n";
    printf "       --steps  Print out each evaluation step\n";
    printf "       --cbn    Use call-by-name evaluation strategy\n"


let main =
  if Array.length Sys.argv < 2 then menu()
  else
    let filename = Sys.argv.(1) in
    evalprog filename 









