
(** A simple implementation of a integer stack *)  

type t
(** Abstract type of the stack *)

val create : unit -> t
(** [create ()] returns a new empty stack. *)

val push : int -> t -> t
(** [push e s] pushes an element [e] to the top of stack [s] and
    returns the new stack *)

val pop : t -> t
(** [pop s] removes the top element from stack [s] and returns the new
    stack. If stack [s] is empty, an empty stack is returned. *)

val top : t -> int option
(** [top s] return the top element of stack [s] as [Some e]. If 
    stack [s] is empty, [None] is returned. *)

val empty : t -> bool
(** [empty s] returns true if stack [s] is empty, else false. *)

