open import Data.Nat
open import Data.List
open import Relation.Binary.PropositionalEquality

module ABT (Op : Set) (sig : Op → List ℕ) where

  data Args : List ℕ → Set

  data ABT : Set where
    Var : ℕ → ABT
    Node : (op : Op) → Args (sig op) → ABT

  data Args where
    nil : Args []
    cons : {b : ℕ} → ABT → {bs : List ℕ} → Args bs → Args (b ∷ bs)

  ext : (ℕ → ℕ) → (ℕ → ℕ)
  ext ρ zero = zero
  ext ρ (suc x) = suc (ρ x)

  extn : ℕ → (ℕ → ℕ) → (ℕ → ℕ)
  extn zero ρ = ρ
  extn (suc n) ρ = extn n (ext ρ)

  ren : (ℕ → ℕ) → ABT → ABT
  rens : (ℕ → ℕ) → {bs : List ℕ} → Args bs → Args bs
  
  ren ρ (Var x) = Var (ρ x)
  ren ρ (Node op args) = Node op (rens ρ args)
  rens ρ nil = nil
  rens ρ (cons {b} M args) = cons (ren (extn b ρ) M) (rens ρ args)

  exts : (ℕ → ABT) → (ℕ → ABT)
  exts σ zero = Var zero
  exts σ (suc x) = ren suc (σ x)
  
  extsn : ℕ → (ℕ → ABT) → (ℕ → ABT)
  extsn zero σ = σ
  extsn (suc n) σ = extsn n (exts σ)

  sub : (ℕ → ABT) → ABT → ABT
  subs : (ℕ → ABT) → {bs : List ℕ} → Args bs → Args bs
  
  sub σ (Var x) = σ x
  sub σ (Node op args) = Node op (subs σ args)
  subs σ nil = nil
  subs σ (cons {b} M args) = cons (sub (extsn b σ) M) (subs σ args)

  scons : ABT → (ℕ → ABT) → (ℕ → ABT)
  scons M σ zero = M
  scons M σ (suc x) = σ x
  
  sub0 : ABT → ABT → ABT
  sub0 M N = sub (scons M (λ x → Var x)) N

{-
  sub-sub0-commute : {N M : ABT}{σ : ℕ → ABT}
    → sub σ (sub0 M N) ≡ sub0 (sub σ M) (sub (exts σ) N)
  sub-sub0-commute = {!!}
-}  
