open import Data.Nat
open import Data.List
open import Relation.Binary.PropositionalEquality

data LamOps : Set where
  op-lam : LamOps
  op-app : LamOps

lam-sig : LamOps → List ℕ
lam-sig op-lam = 1 ∷ []
lam-sig op-app = 0 ∷ 0 ∷ []

open import ABT LamOps lam-sig renaming (ABT to Term)

pattern Lam N = Node op-lam (cons N nil)
pattern App L M = Node op-app (cons L (cons M nil))

eg1 : Term
eg1 = App (Lam (Var 0)) (Var 1)

eg2 : Term
eg2 = sub (λ x → Var (suc x)) eg1

eg2-is : eg2 ≡ App (Lam (Var 0)) (Var 2)
eg2-is = refl

