module ReverseLive where

infix 4 _≡_

data _≡_ {A : Set} (x : A) : (A → Set) where
  refl : x ≡ x

sym : {A : Set} {x y : A} → (x ≡ y) → (y ≡ x)
sym refl = refl

trans : {A : Set} {x y z : A} → x ≡ y → y ≡ z → x ≡ z
trans refl refl  =  refl

cong : {A B : Set} (f : A → B) {x y : A} → x ≡ y → f x ≡ f y
cong f refl  = refl


data ℕ : Set where
  zero : ℕ
  suc : ℕ → ℕ

data List (A : Set) : Set where
  []  : List A
  _∷_ : (x : A) (xs : List A) → List A

infixr 5 _++_

_++_ : {A : Set} → List A → List A → List A
[]       ++ ys = ys
(x ∷ xs) ++ ys = x ∷ (xs ++ ys)

rev : {A : Set} → List A → List A
rev [] = []
rev (x ∷ xs) = rev xs ++ (x ∷ [])

-- rev (xs ++ ys) ≡ rev xs ++ rev ys
-- rev ([1,2] ++ [3,4]) = rev [1,2] ++ rev [3,4] = [2,1] ++ [4,3] = [2,1,4,3]

-- rev (xs ++ ys) ≡ rev ys ++ rev xs
-- rev ([1,2] ++ [3,4]) = rev [3,4] ++ rev [1,2] = [4,3] ++ [2,1] = [4,3,2,1]

--rev ys ≡ rev ys ++ []
-- xs ≡ xs ++ []

append-nil : {A : Set} (xs : List A) → xs ++ [] ≡ xs
append-nil [] = refl
-- append-nil (x ∷ xs') =
--   let IH : xs' ++ [] ≡ xs'
--       IH = append-nil xs' in
--   cong (λ Y → x ∷ Y) IH
append-nil (x ∷ xs')
    with xs' ++ [] | append-nil xs'
append-nil (x ∷ xs') | .xs' | refl = refl  

append-assoc : {A : Set} (xs ys zs : List A) → (xs ++ ys) ++ zs ≡ xs ++ ys ++ zs
append-assoc [] ys zs = refl
append-assoc (x ∷ xs) ys zs =
  let IH : (xs ++ ys) ++ zs ≡ xs ++ ys ++ zs
      IH = append-assoc xs ys zs in
  let step1 :  ((x ∷ xs) ++ ys) ++ zs ≡ x ∷ ((xs ++ ys) ++ zs)
      step1 = refl in
  let step2 :  x ∷ ((xs ++ ys) ++ zs) ≡ x ∷ (xs ++ (ys ++ zs))
      step2 = cong (λ X → x ∷ X) IH in
  let step3 :  x ∷ (xs ++ (ys ++ zs)) ≡ (x ∷ xs) ++ ys ++ zs
      step3 = refl in
  trans step1 (trans step2 step3)

rev-append : {A : Set} (xs ys : List A) → rev (xs ++ ys) ≡ (rev ys) ++ (rev xs)
rev-append [] ys = sym (append-nil (rev ys))
rev-append (x ∷ xs) ys =
  let IH : rev (xs ++ ys) ≡ (rev ys) ++ (rev xs)
      IH = rev-append xs ys in
  let step1 :  rev (xs ++ ys) ++ x ∷ [] ≡ (rev ys ++ rev xs) ++ (x ∷ [])
      step1 = cong (λ X → X ++ x ∷ []) IH in
  let step2 : (rev ys ++ rev xs) ++ (x ∷ []) ≡ rev ys ++ (rev xs ++ (x ∷ []))
      step2 = append-assoc (rev ys) (rev xs) (x ∷ []) in
  trans step1 step2

rev-rev : {A : Set} → (xs : List A) → rev (rev xs) ≡ xs
rev-rev [] = refl
rev-rev (x ∷ xs') =
   let IH : rev (rev xs') ≡ xs'
       IH = rev-rev xs' in
  let step1 :  rev (rev xs' ++ x ∷ []) ≡ (x ∷ []) ++ rev (rev xs')
      step1 = rev-append (rev xs') (x ∷ []) in
  let step2 :  (x ∷ []) ++ rev (rev xs') ≡ (x ∷ []) ++ xs'
      step2 = cong (λ X → (x ∷ []) ++ X) IH in
  let step3 :  (x ∷ []) ++ xs' ≡ x ∷ xs'
      step3 = refl in
  trans step1 (trans step2 step3)
