module LambdaCalculus where

open import Data.Nat
open import Relation.Binary.PropositionalEquality
open import Data.Product using (_×_; Σ; ∃; Σ-syntax; ∃-syntax)
--open ≡-Reasoning

data Term : Set where
  Var : ℕ → Term
  Lam : Term → Term
  App : Term → Term → Term

ext : (ℕ → ℕ) → (ℕ → ℕ)
ext ρ zero = zero
ext ρ (suc x) = suc (ρ x)

ren : (ℕ → ℕ) → Term → Term
ren ρ (Var x) = Var (ρ x)
ren ρ (Lam N) = Lam (ren (ext ρ) N)
ren ρ (App L M) = App (ren ρ L) (ren ρ M)

exts : (ℕ → Term) → (ℕ → Term)
exts σ zero = Var zero
exts σ (suc x) = ren suc (σ x)

sub : (ℕ → Term) → Term → Term
sub σ (Var x) = σ x
sub σ (Lam N) = Lam (sub (exts σ) N)
sub σ (App L M) = App (sub σ L) (sub σ M)

cons : Term → (ℕ → Term) → (ℕ → Term)
cons M σ zero = M
cons M σ (suc x) = σ x

car : (ℕ → Term) → Term
car σ = σ 0

cdr : (ℕ → Term) → (ℕ → Term)
cdr σ x = σ (suc x)

car-cons : ∀ M σ → car (cons M σ) ≡ M
car-cons M σ = refl

cdr-cons : ∀ M σ → cdr (cons M σ) ≡ σ
cdr-cons M σ = refl

sub0 : Term → Term → Term
sub0 M N = sub (cons M (λ x → Var x)) N

infix 2 _—→_

data _—→_ : Term → Term → Set where

  ξ₁ : {L L′ M : Term}
    → L —→ L′
      -------------------
    → App L M —→ App L′ M

  ξ₂ : {L M M′ : Term}
    → M —→ M′
      -------------------
    → App L M —→ App L M′

  β : {N M : Term}
      -------------------------
    → App (Lam N) M —→ sub0 M N

  ζ : {N N′ : Term}
    → N —→ N′
      ---------------
    → Lam N —→ Lam N′

infix  2 _—↠_

data _—↠_ : Term → Term → Set where

  done : (M : Term)
      ------
    → M —↠ M

  step : {L M N : Term}
    → L —→ M
    → M —↠ N
      ------
    → L —↠ N

multi-trans : {L M N : Term}
    → L —↠ M
    → M —↠ N
      ------
    → L —↠ N
multi-trans (done M) MN = MN
multi-trans (step LM MN) NO = step LM (multi-trans MN NO)

appL-cong : {L L' : Term} (M : Term)
         → L —↠ L'
           -------------------
         → App L M —↠ App L' M
appL-cong M (done L) = done (App L M)
appL-cong M (step r rs) = step (ξ₁ r) (appL-cong M rs)

confluence : {L M₁ M₂ : Term}
  → L —↠ M₁ → L —↠ M₂
  → ∃[ N ] (M₁ —↠ N) × (M₂ —↠ N)
confluence LM1 LM2 = {!!}

sub-sub0-commute : {N M : Term}{σ : ℕ → Term}
  → sub σ (sub0 M N) ≡ sub0 (sub σ M) (sub (exts σ) N)
sub-sub0-commute = {!!}

