open HolKernel Parse boolLib bossLib stringTheory combinTheory
     arithmeticTheory finite_mapTheory pairTheory;

val _ = new_theory "demo";

Type name = ``:num``;


(* -- SYNTAX -- *)

(* source *)

Datatype:
  exp = Num num
      | Var name
      | Plus exp exp
End

(* target *)

Datatype:
  inst = Const name num
       | Move name name
       | Add name name name
End

(* -- SEMANTICS -- *)

(* source *)

Inductive eval:
  (T
   ⇒
   eval (Num n, env) n)
  ∧
  ((FLOOKUP env s = SOME v)
   ⇒
   eval (Var s, env) v)
  ∧
  (eval (x1,env) v1 ∧ eval (x2,env) v2
   ⇒
   eval (Plus x1 x2, env) (v1+v2))
End

(* target *)

Definition step_def:
  step (Const s n) state = (s =+ n) state ∧
  step (Move s1 s2) state = (s1 =+ state s2) state ∧
  step (Add s1 s2 s3) state = (s1 =+ state s2 + state s3) state
End

Definition steps_def:
  steps [] state = state ∧
  steps (x::xs) state = steps xs (step x state)
End

(* -- COMPILER -- *)

Definition compile_def:
  compile (Num k) n = [Const n k] ∧
  compile (Var v) n = [Move n v] ∧
  compile (Plus x1 x2) n =
    compile x1 n ++ compile x2 (n+1) ++ [Add n n (n+1)]
End

(* verification proof *)

Theorem steps_append[simp]:
  ∀xs ys state. steps (xs ++ ys) state = steps ys (steps xs state)
Proof
  Induct \\ gvs [steps_def]
QED

Theorem eval_ind = eval_ind |> Q.SPEC ‘λ(x,y) z. P x y z’
                            |> SIMP_RULE (srw_ss()) [FORALL_PROD] |> GEN_ALL;

Theorem compile_correct:
  ∀x env res.
    eval (x, env) res ⇒
    ∀k state.
      (∀i v. (FLOOKUP env i = SOME v) ⇒ (state i = v) ∧ i < k) ⇒
      let state' = steps (compile x k) state in
        (state' k = res) ∧
        ∀i. i < k ⇒ (state' i = state i)
Proof
  ho_match_mp_tac eval_ind \\ rpt strip_tac
  \\ gvs [compile_def,steps_def,step_def,APPLY_UPDATE_THM]
  \\ last_x_assum drule \\ strip_tac
  \\ qabbrev_tac ‘state_1 = steps (compile x k) state’
  \\ gvs []
  \\ last_x_assum $ qspecl_then [‘k+1’,‘state_1’] mp_tac
  \\ impl_tac >- (rw [] \\ res_tac \\ simp [])
  \\ strip_tac \\ gvs []
QED

val _ = export_theory();
