Require Import Arith Bool List ZArith List.

Import ListNotations.
From QuickChick Require Import QuickChick. Import QcNotation.

Require Export ExtLib.Structures.Monads.
Export MonadNotation. Open Scope monad_scope.


Fixpoint remove (x: nat) (l: list nat): list nat :=
  match l with
  | nil => nil
  | y :: ys => if x =? y then remove x ys else y :: remove x ys
  end.

Conjecture remove_property : forall x l, ~In x (remove x l).

QuickChick remove_property.



Section TypeClasses.

Local Open Scope string.

Class Show A : Type :=
  {
    show : A -> string
  }.

Instance showBool : Show bool :=
  {
    show := fun b:bool => if b then "true" else "false"
  }.

Fixpoint string_of_nat_aux (time n : nat) (acc : string) : string :=
  let d := match n mod 10 with
           | 0 => "0" | 1 => "1" | 2 => "2" | 3 => "3" | 4 => "4" | 5 => "5"
           | 6 => "6" | 7 => "7" | 8 => "8" | _ => "9"
           end in
  let acc' := d ++ acc in
  match time with
    | 0 => acc'
    | S time' =>
      match n / 10 with
        | 0 => acc'
        | n' => string_of_nat_aux time' n' acc'
      end
  end.

Definition string_of_nat (n : nat) : string :=
  string_of_nat_aux n n "".

#[export] Instance showNat : Show nat :=
  {
    show := string_of_nat
  }.

Compute show true.
Compute show 42.

Generalizable Variables A.

Instance showOption `{Show A} : Show (option A) :=
  {
    show o :=
      match o with
        | None => "None"
        | Some x => "Some " ++ show x
      end
  }.

Compute show (Some 10).
Compute show (Some true).



(** Decidability ************************************)
Class DecEq A :=
  {
    dec_eq : forall x y : A, {x = y} + {x <> y}
  }.

Instance NatDecEq : DecEq nat.
  constructor.
  decide equality.
Defined.

Compute dec_eq 1 2.
Compute if dec_eq 1 2 then true else false.

Class Decidable (P : Prop) :=
  {
    dec : {P} + {~P}
  }.

Instance DecEqDec `{eqDec: DecEq A} {x y : A}: Decidable (x = y).
  constructor.
  destruct eqDec as [eqDec]. auto.
Defined.

Compute if (@dec (1 = 2) _) then true else false.

Hint Unfold In.

Instance decideIn `{eqDec: DecEq A} {x : A} {l : list A}: Decidable (In x l).
  constructor.
  induction l; intros; auto.
  destruct eqDec as [eqDec].
  destruct (eqDec x a); auto.
  inversion IHl as [HIn | HnIn]; auto.
  right. intros contra.
  inversion contra; auto.
Defined.

Compute if @dec (In 5 [1;2;3]) _ then true else false.

End TypeClasses.
