package se.kth.anderslm.state;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.widget.EditText;

/**
 * This class demonstrates when Activity state call backs are executed
 * during the activity's life cycle. Use Logcat to view the Log.i-
 * messages.
 * Compare what methods are called when you press the the device's 
 * home button and back button respectively. Restart the application
 * through the device's list of applications.
 */
public class SaveActivity extends Activity {
	
	public static final String PREFS = "SaveActivityPrefs";
	private EditText textInput;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i("SaveActivity", "onCreate called");
        
        this.setContentView(R.layout.main);
        textInput = (EditText) findViewById(R.id.InputText);
        
        // Restore UI state
        SharedPreferences settings = getSharedPreferences(PREFS, MODE_PRIVATE);       
        String currentInput = settings.getString("text_input", "");      
        textInput.setText(currentInput);
    }
    
    protected void onStart() {
    	super.onStart();
    	Log.i("SaveActivity", "onStart called");  
    }
    
    protected void onResume() {
    	super.onResume();
    	Log.i("SaveActivity", "onResume called");  
    }
    
    /**
     * Save state in onPause. After onPause has been called
     * (after onStart since ver 3.0) the application is "killable".
     */
    protected void onPause() {
    	super.onPause();
    	Log.i("SaveActivity", "onPause called"); 
    	
    	String currentInput = textInput.getText().toString();
    	// Save UI state; get a SharedPreferences editor 
    	SharedPreferences settings = getSharedPreferences(PREFS, MODE_PRIVATE);      
    	SharedPreferences.Editor editor = settings.edit();      
    	editor.putString("text_input", currentInput);      
    	// Commit the edits
    	editor.commit();
    }
    
    protected void onStop() {
    	super.onStop();
    	Log.i("SaveActivity", "onStop called");  
    }
    
    protected void onDestroy() {
    	super.onDestroy();
    	Log.i("SaveActivity", "onDestroy called");  
    }
}