package se.kth.temperature;


import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.Toast;

public class TemperatureActivity extends Activity {
	
	private EditText textInput ;
	private RadioButton celciusButton;
	private RadioButton fahrenheitButton;
	private Button calculateButton;
	private TextView textOutput;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		textInput  = (EditText) findViewById(R.id.TextInput);
		celciusButton = (RadioButton) findViewById(R.id.CelciusButton);
		fahrenheitButton = (RadioButton) findViewById(R.id.FahrenheitButton);
		calculateButton = (Button) findViewById(R.id.CalculateButton);
		textOutput = (TextView) findViewById(R.id.TextOutput);
		
		// Create a listener and associate it with the button
		OnClickListener listener = new ButtonListener();
		calculateButton.setOnClickListener(listener);
	}

	/**
	 * This class defines the action to take when one the calculate button 
	 * is clicked, in this case by calling buttonClickHandler().
	 */
	private class ButtonListener implements OnClickListener {

		public void onClick(View v) {
			buttonClickHandler();
		}	
	}
	
	private void buttonClickHandler() {
		String text = textInput.getText().toString();
		if(text.length() == 0) {
			showToast("Please enter a a valid number");
			return;
		}
		
		float value = Float.parseFloat(text);
		String result = ""; 
		if(celciusButton.isChecked()) {
			float c = convertFahrenheitToCelsius(value);
			result = "" + c + " Celsius";
		}
		else if(fahrenheitButton.isChecked()) {
			float f = convertCelsiusToFahrenheit(value);
			result = "" + f + " Fahrenheit";
		}
		else {
			showToast("Please select a radio button");
			return;
		}

		textOutput.setText(result);
	}

	private float convertFahrenheitToCelsius(float fahrenheit) {
		return ((fahrenheit - 32) * 5 / 9);
	}

	private float convertCelsiusToFahrenheit(float celsius) {
		return ((celsius * 9) / 5) + 32;
	}
	
	private void showToast(String msg) {
		Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
		toast.show();
	}
}

