function x=newton(fname,x0,tol,maxit)
%NEWTON - Newton's method for solving nonlinear equations
%X=NEWTON(X0,TOL,MAXIT)
x=x0;
n=0;
done=false;
while ~done
    n=n+1;
    [f,fprim]=feval(fname,x);
    x_new=x-f/fprim;
    done=(n>maxit)|(abs(x_new-x)<tol);
    x=x_new;
end

