/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.core.text;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class LineTracker {
    private char[] lines = new char[100];
    private int end = 0;

    public void addLineStart(char line) {
        if (this.end == this.lines.length) {
            this.growLines();
        }
        this.lines[this.end] = line;
        ++this.end;
    }

    public int size() {
        return this.lines.length;
    }

    public int getLineOffset(int line) {
        return this.lines[line];
    }

    public IRegion getLineForOffset(int offset) {
        int i = 0;
        while (i < this.end && offset > this.lines[i]) {
            ++i;
        }
        if (i > 0 && i < this.end) {
            return new Region((int)this.lines[i - 1], this.lines[i] - this.lines[i - 1]);
        }
        return null;
    }

    private void growLines() {
        char[] tmp = new char[this.lines.length + 10];
        System.arraycopy(this.lines, 0, tmp, 0, this.lines.length);
        this.lines = tmp;
    }
}

