/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.Constants;
import com.interaktonline.jseclipse.dialogs.WelcomeDialog;
import com.interaktonline.jseclipse.editors.JSCodeScanner;
import com.interaktonline.jseclipse.editors.JSColorProvider;
import com.interaktonline.jseclipse.editors.JSPartitionScanner;
import com.interaktonline.jseclipse.editors.JavaDocScanner;
import com.interaktonline.jseclipse.editors.JsCommentScanner;
import com.interaktonline.jseclipse.util.JsPluginImages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JavaScriptEditorPlugin
extends AbstractUIPlugin {
    private static JavaScriptEditorPlugin plugin;
    private ResourceBundle resourceBundle;
    private BundleContext bundleContext;
    private TemplateStore fStore;
    private ContributionContextTypeRegistry fRegistry;
    private static final String JSECLIPSE_TEMPLATES = "com.interaktonline.jseclipse.templates";
    public static final String JAVASCRIPT_PARTITIONING = "___javascript_partitioning";
    private JSPartitionScanner fPartitionScanner;
    private Map fColorProvider;
    private Map fCodeScanner;
    private Map fDocScanner;
    private Map fSingleLineCommentScanner;
    private Map fMultiLineCommentScanner;

    public JavaScriptEditorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        Logger logger = Logger.getLogger("com.interaktonline.jseditor.log");
        IPath loc = JavaScriptEditorPlugin.getDefault().getStateLocation();
        String logFileStr = String.valueOf(loc.toString()) + "/LogToFile.txt";
        FileHandler logFile = new FileHandler(logFileStr);
        logFile.setFormatter(new SimpleFormatter());
        logger.addHandler(logFile);
        logger.setLevel(Level.ALL);
        logger.info("JSEclipse start");
        JsPluginImages.initPluginImages();
        this.inflateReferences();
        this.fColorProvider = new HashMap();
        this.fCodeScanner = new HashMap();
        this.fDocScanner = new HashMap();
        this.fSingleLineCommentScanner = new HashMap();
        this.fMultiLineCommentScanner = new HashMap();
        if (this.isFirstTime()) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            final WelcomeDialog dialog = new WelcomeDialog(window.getShell());
            Job job = new Job("welcome job"){

                protected IStatus run(IProgressMonitor monitor) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this, dialog){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ WelcomeDialog val$dialog;
                        {
                            this.this$1 = var1_1;
                            this.val$dialog = welcomeDialog;
                        }

                        public void run() {
                            this.val$dialog.open();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule(5000L);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
        this.bundleContext = null;
    }

    public static JavaScriptEditorPlugin getDefault() {
        return plugin;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            this.fRegistry.addContextType("com.interaktonline.jseclipse.template.context");
        }
        return this.fRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), JavaScriptEditorPlugin.getDefault().getPreferenceStore(), JSECLIPSE_TEMPLATES);
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                JavaScriptEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.examples.javaeditor", 0, "", (Throwable)e));
            }
        }
        return this.fStore;
    }

    public JSPartitionScanner getJavaPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new JSPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public RuleBasedScanner getJSCodeScanner(IPreferenceStore preferenceStore) {
        JSCodeScanner lCodeScanner = (JSCodeScanner)((Object)this.fCodeScanner.get(preferenceStore));
        if (lCodeScanner == null) {
            lCodeScanner = new JSCodeScanner(this.getJSColorProvider(preferenceStore));
            this.fCodeScanner.put(preferenceStore, lCodeScanner);
        }
        return lCodeScanner;
    }

    public void refreshJSCodeScanner(IPreferenceStore preferenceStore) {
        JSCodeScanner lCodeScanner = new JSCodeScanner(this.getJSColorProvider(preferenceStore));
        this.fCodeScanner.put(preferenceStore, lCodeScanner);
    }

    public JSColorProvider getJSColorProvider(IPreferenceStore preferenceStore) {
        JSColorProvider lColorProvider = (JSColorProvider)this.fColorProvider.get(preferenceStore);
        if (lColorProvider == null) {
            lColorProvider = new JSColorProvider(preferenceStore);
            this.fColorProvider.put(preferenceStore, lColorProvider);
        }
        return lColorProvider;
    }

    public RuleBasedScanner getJSDocScanner(IPreferenceStore preferenceStore) {
        JavaDocScanner lDocScanner = (JavaDocScanner)((Object)this.fDocScanner.get(preferenceStore));
        if (lDocScanner == null) {
            lDocScanner = new JavaDocScanner(this.getJSColorProvider(preferenceStore));
            this.fDocScanner.put(preferenceStore, lDocScanner);
        }
        return lDocScanner;
    }

    public RuleBasedScanner getJSSinglelineCommentScanner(IPreferenceStore preferenceStore) {
        JsCommentScanner lSingleLineCommentScanner = (JsCommentScanner)((Object)this.fSingleLineCommentScanner.get(preferenceStore));
        if (lSingleLineCommentScanner == null) {
            lSingleLineCommentScanner = new JsCommentScanner(this.getJSColorProvider(preferenceStore), "singlelineCommentColor");
            this.fSingleLineCommentScanner.put(preferenceStore, lSingleLineCommentScanner);
        }
        return lSingleLineCommentScanner;
    }

    public RuleBasedScanner getJSMultilineCommentScanner(IPreferenceStore preferenceStore) {
        JsCommentScanner lMultiLineCommentScanner = (JsCommentScanner)((Object)this.fMultiLineCommentScanner.get(preferenceStore));
        if (lMultiLineCommentScanner == null) {
            lMultiLineCommentScanner = new JsCommentScanner(this.getJSColorProvider(preferenceStore), "multilineCommentColor");
            this.fMultiLineCommentScanner.put(preferenceStore, lMultiLineCommentScanner);
        }
        return lMultiLineCommentScanner;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JavaScriptEditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("com.interaktonline.jseclipse.Messages");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jseclipse", (String)path);
    }

    public boolean isFirstTime() {
        return false;
    }

    public void inflateReferences() {
        IPath loc = JavaScriptEditorPlugin.getDefault().getStateLocation();
        File f = new File(String.valueOf(loc.toString()) + "/references/");
        if (!f.exists()) {
            String pathSuffix = "references/";
            URL refBaseURL = null;
            try {
                refBaseURL = new URL(this.getBundle().getEntry("/"), pathSuffix);
                int i = 0;
                while (i < Constants.REFERENCES.length) {
                    String folderName = Constants.REFERENCES[i];
                    int ix = folderName.lastIndexOf(46);
                    if (ix != -1) {
                        folderName = folderName.substring(0, ix);
                    }
                    URL url = new URL(refBaseURL, Constants.REFERENCES[i]);
                    FileTools.inflate(new BufferedInputStream(url.openStream()), String.valueOf(f.getCanonicalPath()) + "/" + folderName);
                    ++i;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

