/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class CodeCommentAction
extends TextEditorAction {
    private ITextViewer fTextViewer;
    private boolean firstLineCommented = false;
    private int change = 0;

    public CodeCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor, int style, ITextViewer textViewer) {
        super(bundle, prefix, editor, style);
        this.fTextViewer = textViewer;
        this.setActionDefinitionId("com.interaktonline.jseclipse.editors.codeComment");
    }

    public void run() {
        IDocument doc = this.fTextViewer.getDocument();
        int selectionBegin = this.fTextViewer.getSelectedRange().x;
        int selectionLength = this.fTextViewer.getSelectedRange().y;
        try {
            int startLine = doc.getLineOfOffset(selectionBegin);
            int endLine = doc.getLineOfOffset(selectionBegin + selectionLength);
            IRegion startLineInfo = doc.getLineInformation(startLine);
            IRegion endLineInfo = doc.getLineInformation(endLine);
            int newReplBegin = startLineInfo.getOffset();
            int newReplLength = endLineInfo.getOffset() + endLineInfo.getLength() - newReplBegin;
            boolean ignoreLast = false;
            if (startLine != endLine && endLineInfo.getOffset() == selectionBegin + selectionLength) {
                ignoreLast = true;
            }
            String selectedText = this.getCommentedLines(doc, startLine, endLine + 1, ignoreLast);
            doc.replace(newReplBegin, newReplLength, selectedText);
            int newSelBegin = selectionBegin;
            int newSelLength = selectionLength;
            if (selectionBegin > startLineInfo.getOffset()) {
                if (this.firstLineCommented) {
                    newSelBegin += 2;
                    this.change -= 2;
                } else {
                    newSelBegin -= 2;
                    this.change += 2;
                }
            }
            this.fTextViewer.setSelectedRange(newSelBegin, newSelLength += this.change);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String getCommentedLines(IDocument doc, int startLine, int endLine, boolean ignoreLast) throws BadLocationException {
        String selectedText;
        IRegion reg;
        StringBuffer sb = new StringBuffer();
        this.firstLineCommented = false;
        boolean comment = false;
        this.change = 0;
        int theEnd = endLine;
        if (ignoreLast) {
            --theEnd;
        }
        int i = startLine;
        while (i < theEnd) {
            reg = doc.getLineInformation(i);
            selectedText = doc.get(reg.getOffset(), reg.getLength());
            comment |= !selectedText.startsWith("//");
            ++i;
        }
        i = startLine;
        while (i < endLine) {
            reg = doc.getLineInformation(i);
            selectedText = doc.get(reg.getOffset(), reg.getLength());
            if (ignoreLast && i == endLine - 1) {
                sb.append(selectedText);
            } else if (comment) {
                if (i == startLine) {
                    this.firstLineCommented = true;
                }
                sb.append("//").append(selectedText);
                this.change += 2;
            } else {
                sb.append(selectedText.substring(2));
                this.change -= 2;
            }
            if (i != endLine - 1) {
                sb.append(doc.getLineDelimiter(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

