/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.actions;

import com.interaktonline.jseclipse.contentassist.ContentAssistTools;
import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.library.JsLibraryManager;
import com.interaktonline.jseclipse.library.Library;
import com.interaktonline.jseclipse.library.LibraryItem;
import com.interaktonline.jseclipse.library.LibraryProject;
import com.interaktonline.jseclipse.text.JsDocument;
import com.interaktonline.jseclipse.util.TextSearchUtils;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class OpenDeclarationAction
extends TextEditorAction {
    private ITextViewer fTextViewer;
    private IFile file;

    public OpenDeclarationAction(ResourceBundle bundle, String prefix, ITextEditor editor, int style, ITextViewer textViewer) {
        super(bundle, prefix, editor, style);
        this.fTextViewer = textViewer;
        IEditorInput iei = editor.getEditorInput();
        if (!(iei instanceof FileEditorInput)) {
            return;
        }
        FileEditorInput fei = (FileEditorInput)iei;
        this.file = fei.getFile();
        this.setActionDefinitionId("com.interaktonline.jseclipse.editors.openDeclaration");
    }

    public void run() {
        JsDocNode theroot;
        JsNode node;
        LibraryItem li;
        Library lib;
        JsDocument doc = (JsDocument)this.fTextViewer.getDocument();
        int documentOffset = this.fTextViewer.getSelectedRange().x;
        String text = doc.get();
        int start = TextSearchUtils.getStart2(text, documentOffset);
        if (start < 0) {
            return;
        }
        int end = documentOffset;
        while (Character.isJavaIdentifierPart(text.charAt(end)) && end < text.length() - 1) {
            ++end;
        }
        String string = text.substring(start, end).trim();
        if (string.length() == 0) {
            return;
        }
        String[] completionPath = string.split("\\.", -1);
        int dotix = string.indexOf(46);
        boolean dot = dotix != -1;
        String prefix = "";
        String rest = completionPath[completionPath.length - 1];
        prefix = !dot ? completionPath[0] : completionPath[completionPath.length - 2];
        String classPrefix = ContentAssistTools.getClassFor((IDocument)doc, documentOffset, prefix);
        JsLibraryManager manager = JsLibraryManager.getInstance();
        LibraryProject project = manager.getProject(this.file.getProject().getName());
        if (!classPrefix.equals(prefix)) {
            completionPath = new String[]{classPrefix, rest};
        }
        if ((lib = project.getLibrary(completionPath, 0, completionPath.length - 2)) != null && (li = lib.getItem(rest, false)) != null) {
            this.openFile(li);
            return;
        }
        lib = project.getLibrary(completionPath, 0, completionPath.length - 1);
        if (lib != null) {
            li = lib.getItem(rest, false);
            if (li == null) {
                li = lib.getItem(0);
            }
            if (li != null) {
                this.openFile(li);
            }
        }
        if ((node = (theroot = doc.getJsDocNode()).getChildNode(rest)) != null) {
            this.getTextEditor().selectAndReveal(node.getOffset(), 0);
        }
    }

    private void openFile(LibraryItem li) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Library.LibraryFile libFile = li.getFileOwner();
        if (libFile == null) {
            return;
        }
        IFile lfile = workspace.getRoot().getFileForLocation((IPath)new Path(libFile.getPath()));
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dwindow.getActivePage();
        try {
            TextEditor editor = (TextEditor)page.openEditor((IEditorInput)new FileEditorInput(lfile), "com.interaktonline.jseclipse.editors.JsEditor");
            if (li != null) {
                this.selectMethod(editor, li);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void selectMethod(TextEditor editor, LibraryItem li) {
        if (li != null && li.getLocation() != -1) {
            try {
                IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                int pos = doc.getLineOffset(li.getLocation());
                editor.selectAndReveal(pos, 0);
            }
            catch (Exception exception) {}
        }
    }
}

