/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.actions.utils;

import com.interaktonline.jseclipse.text.TextUtilities;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;

public class GotoMatchingBracket {
    private char OP_BRACKET = (char)32;
    private char BRACKET = (char)32;
    private int direction = 0;
    private IDocument fDocument;

    public int getPair(IDocument document, int offset) {
        if (offset == 0) {
            return -1;
        }
        String text = document.get();
        char c = text.charAt(offset - 1);
        this.direction = this.isLeftBracket(c);
        if (this.direction == 0) {
            this.direction = this.isRightBracket(c);
        }
        if (this.direction == 0) {
            return -1;
        }
        this.fDocument = document;
        return this.getPositionForOtherMatch(text, offset);
    }

    public void performe(boolean select, ITextViewer fTextViewer) {
        int newSelEnd;
        this.fDocument = fTextViewer.getDocument();
        int selectionBegin = fTextViewer.getSelectedRange().x;
        int selectionLength = fTextViewer.getSelectedRange().y;
        if (selectionLength != 0 || selectionBegin == 0) {
            return;
        }
        String text = this.fDocument.get();
        char c = text.charAt(selectionBegin - 1);
        this.direction = this.isLeftBracket(c);
        if (this.direction == 0) {
            this.direction = this.isRightBracket(c);
        }
        if (this.direction == 0) {
            return;
        }
        int selectionEnd = this.getPositionForOtherMatch(text, selectionBegin);
        if (selectionEnd == -1) {
            return;
        }
        int newSelBegin = this.direction < 0 ? selectionEnd : selectionBegin;
        int n = newSelEnd = this.direction < 0 ? selectionBegin : selectionEnd;
        if (select) {
            fTextViewer.setSelectedRange(newSelBegin, newSelEnd - newSelBegin);
            fTextViewer.revealRange(newSelBegin, newSelEnd - newSelBegin);
        } else {
            fTextViewer.setSelectedRange(selectionEnd + 1, 0);
            fTextViewer.revealRange(selectionEnd + 1, 0);
        }
    }

    private int getPositionForOtherMatch(String text, int start) {
        int end = this.direction > 0 ? text.length() - 1 : 0;
        int i = this.direction > 0 ? start : start - 2;
        int inside = 0;
        while (this.ok(i, end)) {
            if (text.charAt(i) == this.BRACKET && TextUtilities.isPartition(this.fDocument, i, "__dftl_partition_content_type")) {
                ++inside;
            } else if (text.charAt(i) == this.OP_BRACKET && TextUtilities.isPartition(this.fDocument, i, "__dftl_partition_content_type")) {
                if (inside > 0) {
                    --inside;
                } else {
                    return i;
                }
            }
            i += this.direction;
        }
        return -1;
    }

    private boolean ok(int i, int end) {
        if (this.direction > 0) {
            return i <= end;
        }
        return i >= end;
    }

    private int isLeftBracket(char c) {
        switch (c) {
            case '{': {
                this.BRACKET = (char)123;
                this.OP_BRACKET = (char)125;
                return 1;
            }
            case '[': {
                this.BRACKET = (char)91;
                this.OP_BRACKET = (char)93;
                return 1;
            }
            case '(': {
                this.BRACKET = (char)40;
                this.OP_BRACKET = (char)41;
                return 1;
            }
        }
        return 0;
    }

    private int isRightBracket(char c) {
        switch (c) {
            case '}': {
                this.BRACKET = (char)125;
                this.OP_BRACKET = (char)123;
                return -1;
            }
            case ']': {
                this.BRACKET = (char)93;
                this.OP_BRACKET = (char)91;
                return -1;
            }
            case ')': {
                this.BRACKET = (char)41;
                this.OP_BRACKET = (char)40;
                return -1;
            }
        }
        return 0;
    }
}

