/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class CompletionContextValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    protected int fInstallOffset;
    protected IContextInformation fInstallInfo;
    protected ITextViewer fViewer;
    protected boolean isValid = true;
    private StyleRange fStyle;

    public boolean isContextInformationValid(int offset) {
        if (offset < this.fInstallOffset) {
            return false;
        }
        return this.isValid;
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        this.isValid = true;
        this.fInstallInfo = info;
        this.fInstallOffset = offset;
        this.fViewer = viewer;
        String text = this.fInstallInfo.getInformationDisplayString();
        int end = text.indexOf(44);
        if (end == -1) {
            end = text.length();
        }
        this.fStyle = new StyleRange(0, end, new Color(null, 255, 0, 0), null);
    }

    public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
        char c;
        try {
            c = this.fViewer.getDocument().getChar(documentPosition - 1);
        }
        catch (BadLocationException badLocationException) {
            this.isValid = false;
            return false;
        }
        if (c == ',') {
            String text = this.fInstallInfo.getInformationDisplayString();
            this.fStyle.start = this.fStyle.start + this.fStyle.length + 1;
            int end = text.indexOf(44, this.fStyle.start + 1);
            this.fStyle.length = end == -1 ? text.length() - this.fStyle.start : end - this.fStyle.start;
        } else if (c == ')') {
            this.isValid = false;
            return false;
        }
        presentation.addStyleRange(this.fStyle);
        return true;
    }
}

