/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.contentassist;

import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.text.JsDocument;
import com.interaktonline.jseclipse.text.TextUtilities;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class ContentAssistTools {
    private ContentAssistTools() {
    }

    public static String getClassFor(IDocument document, int offset, String prefix) {
        String text = document.get();
        JsDocNode jsdoc = ((JsDocument)document).getJsDocNode();
        Position[] pos = jsdoc.getOverlappingPositions(offset, 0);
        int cfr_ignored_0 = pos.length;
        String className = ContentAssistTools.getParameterType(document, offset, prefix);
        if (className != null) {
            return className;
        }
        className = ContentAssistTools.getVarParameterType(document, offset, prefix);
        if (className != null) {
            return className;
        }
        className = ContentAssistTools.getClassName(document, offset, prefix);
        if (className != null) {
            if (className.endsWith("document.getElementById")) {
                return "element";
            }
            if (className.equals("function")) {
                return prefix;
            }
            return className;
        }
        if (ContentAssistTools.isString(text, offset, prefix)) {
            return "String";
        }
        return prefix;
    }

    private static String getVarParameterType(IDocument document, int offset, String prefix) {
        String text = document.get();
        Pattern p = Pattern.compile("var\\s+/\\*\\*\\s*(\\w+)\\s*\\*/\\s*" + prefix);
        Matcher m = p.matcher(text);
        String found = null;
        while (m.find()) {
            if (m.start(1) >= offset) break;
            found = m.group(1);
        }
        return found;
    }

    private static String getParameterType(IDocument document, int offset, String prefix) {
        int sline;
        Matcher m;
        String toSearch;
        Pattern p;
        int iy;
        String text;
        block10: {
            block9: {
                text = document.get();
                int ix = text.lastIndexOf("function", offset);
                if (ix == -1) {
                    return null;
                }
                iy = text.indexOf(123, ix);
                if (iy == -1) {
                    return null;
                }
                p = Pattern.compile("/\\*\\*\\s*(\\w+)\\s*\\*/\\s*" + prefix);
                m = p.matcher(toSearch = text.substring(ix, iy));
                if (m.find()) {
                    return m.group(1);
                }
                try {
                    int fline = document.getLineOfOffset(ix);
                    sline = document.getLineOffset(fline);
                    while (sline > 1 && Character.isWhitespace(document.getChar(sline - 1))) {
                        --sline;
                    }
                    if (sline > 1 && document.getChar(sline - 1) == '/' && document.getChar(sline - 2) == '*') break block9;
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            iy = text.lastIndexOf("/**", sline);
            if (iy >= 0) break block10;
            return null;
        }
        p = Pattern.compile("@param\\s*\\{(\\w+)\\}\\s*" + prefix);
        toSearch = text.substring(iy, sline);
        m = p.matcher(toSearch);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static String getClassName(IDocument document, int offset, String prefix) {
        String className = null;
        String newClassPattern = "\\b" + prefix + "\\s*=\\s*new\\s+([\\w\\.]+)";
        String assignObjectPattern = "\\b" + prefix + "\\s*=\\s*([\\w\\.]+)";
        className = ContentAssistTools.searchForPattern(document, offset, newClassPattern);
        if (className == null) {
            className = ContentAssistTools.searchForPattern(document, offset, assignObjectPattern);
        }
        return className;
    }

    private static String searchForPattern(IDocument document, int offset, String pattern) {
        String className = null;
        String text = document.get();
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(text);
        while (m.find()) {
            if (!TextUtilities.isPartition(document, m.start(1), "__dftl_partition_content_type")) continue;
            if (m.start(1) < offset) {
                className = m.group(1);
                continue;
            }
            if (className != null) continue;
            className = m.group(1);
            break;
        }
        return className;
    }

    private static boolean isString(String text, int offset, String prefix) {
        Pattern p = Pattern.compile("\\b" + prefix + "\\s*=\\s*['\"][\\w\\s]*['\"]");
        Matcher m = p.matcher(text);
        return m.find();
    }
}

