/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.contentassist;

import com.interaktonline.jseclipse.library.HtmlLibraryManager;
import com.interaktonline.jseclipse.library.LibraryItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class HtmlIdCompletionProcessor
implements IContentAssistProcessor {
    private HashMap tester = new HashMap();

    private String getHtmlContext(String text, int offset) {
        if (offset == 0) {
            return null;
        }
        int i = offset - 1;
        while (i >= 0 && Character.isJavaIdentifierPart(text.charAt(i))) {
            --i;
        }
        String rest = i + 1 == offset ? "" : text.substring(i + 1, offset);
        int mark = i -= 2;
        while (i >= 0 && (Character.isJavaIdentifierPart(text.charAt(i)) || '$' == text.charAt(i))) {
            --i;
        }
        if (i < 0) {
            return null;
        }
        String prev = text.substring(i + 1, mark + 1);
        if (!prev.equals("getElementById") && !prev.equals("$")) {
            return null;
        }
        if (i + 1 == offset) {
            return "";
        }
        return rest;
    }

    private ICompletionProposal[] getHtmlCompletions(String text, int offset) {
        String rest = this.getHtmlContext(text, offset);
        if (rest == null) {
            return null;
        }
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dwindow.getActivePage();
        IEditorInput iei = page.getActiveEditor().getEditorInput();
        if (!(iei instanceof FileEditorInput)) {
            return new ICompletionProposal[0];
        }
        FileEditorInput fei = (FileEditorInput)iei;
        IFile file = fei.getFile();
        int starter = file.getProject().getLocation().toString().length();
        String title = page.getActiveEditor().getTitle();
        HtmlLibraryManager manager = HtmlLibraryManager.getInstance();
        ArrayList proposals = manager.getProject(file.getProject().getName()).get(null, new String[]{title, rest}, true);
        if (proposals == null) {
            return null;
        }
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        LibraryItem li = null;
        this.tester.clear();
        int i = 0;
        while (i < proposals.size()) {
            li = (LibraryItem)proposals.get(i);
            String repl = li.getReplacement().substring(rest.length());
            String path = li.getFileOwner().getPath().substring(starter);
            if (!this.tester.containsKey(repl)) {
                int cursorPosition = repl.length();
                result.add(new CompletionProposal(repl, offset, 0, cursorPosition, null, li.getDisplay(false), null, path));
            }
            this.tester.put(repl, "");
            ++i;
        }
        ICompletionProposal[] ret = new ICompletionProposal[result.size()];
        result.toArray(ret);
        return ret;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String text = viewer.getDocument().get();
        ICompletionProposal[] result = null;
        result = this.getHtmlCompletions(text, offset);
        if (result == null) {
            return null;
        }
        ICPcompare c = new ICPcompare();
        Arrays.sort(result, c);
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'\"', '\''};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private class ICPcompare
    implements Comparator {
        private ICPcompare() {
        }

        public int compare(Object arg0, Object arg1) {
            ICompletionProposal o1 = (ICompletionProposal)arg0;
            ICompletionProposal o2 = (ICompletionProposal)arg1;
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
    }
}

