/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.contentassist;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.contentassist.CompletionContextValidator;
import com.interaktonline.jseclipse.contentassist.ContentAssistTools;
import com.interaktonline.jseclipse.contentassist.JSStaticCompletions;
import com.interaktonline.jseclipse.contentassist.ThisCompletionProcessor;
import com.interaktonline.jseclipse.editors.OpenedFilesProposals;
import com.interaktonline.jseclipse.library.JsLibraryManager;
import com.interaktonline.jseclipse.library.LibraryProject;
import com.interaktonline.jseclipse.text.JsDocument;
import com.interaktonline.jseclipse.util.JsPluginImages;
import com.interaktonline.jseclipse.util.TextSearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class JSCompletionProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor {
    protected IContextInformationValidator fValidator = new CompletionContextValidator();
    private ArrayList proposals = new ArrayList();
    private HashMap tester = new HashMap();
    private IFile file;
    private IPreferenceStore fstore;
    protected ThisCompletionProcessor fThisCompletionProcessor = new ThisCompletionProcessor();

    public JSCompletionProcessor() {
        this.fstore = JavaScriptEditorPlugin.getDefault().getPreferenceStore();
    }

    private ICompletionProposal[] getFileCompletionsFor(String text, String prefix, String rest, int offset, boolean dot) {
        int compLength;
        String toComplete;
        this.proposals.clear();
        this.tester.clear();
        if (rest.length() == 0) {
            if (dot) {
                toComplete = String.valueOf(prefix) + "\\.";
                compLength = toComplete.length() - 1;
            } else {
                toComplete = prefix;
                compLength = toComplete.length();
            }
        } else {
            toComplete = rest;
            if (prefix.trim().length() != 0) {
                offset += prefix.length() + 1;
            }
            compLength = toComplete.length();
        }
        String projectName = this.file.getProject().getName();
        LibraryProject project = JsLibraryManager.getInstance().getProject(projectName);
        ArrayList libPrefixes = project.getPrefixes(toComplete, true);
        ArrayList globals = JsLibraryManager.getInstance().getGlobalProject().getPrefixes(toComplete, true);
        libPrefixes.addAll(globals);
        int i = 0;
        while (i < libPrefixes.size()) {
            String repl = libPrefixes.get(i).toString();
            if (!this.tester.containsKey(repl)) {
                this.proposals.add(new CompletionProposal(repl, offset, compLength, repl.length(), JsPluginImages.get("namespace.gif"), repl, null, null));
                this.tester.put(repl, "");
            }
            ++i;
        }
        this.getCompletionsFromOpenedFiles(prefix, rest, offset, compLength, dot);
        Pattern completions = Pattern.compile("(?:^|\\W)(" + toComplete + "\\w+)", 2);
        Matcher m = completions.matcher(text);
        while (m.find()) {
            String repl = m.group(1);
            if (this.tester.containsKey(repl)) continue;
            this.proposals.add(new CompletionProposal(repl, offset, compLength, repl.length(), JsPluginImages.get("var.gif"), repl, null, "word from current file"));
            this.tester.put(repl, "");
        }
        ICompletionProposal[] ret = new ICompletionProposal[this.proposals.size()];
        this.proposals.toArray(ret);
        return ret;
    }

    private void getCompletionsFromOpenedFiles(String prefix, String rest, int offset, int compLength, boolean dot) {
        String toComplete = prefix;
        if (rest.length() != 0) {
            toComplete = String.valueOf(toComplete) + "." + rest;
        } else if (dot) {
            toComplete = String.valueOf(toComplete) + ".";
        }
        List list = OpenedFilesProposals.getInstance().getCompletionsFor(toComplete, true);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String[] repl = (String[])it.next();
            String replStr = rest.length() != 0 ? String.valueOf(repl[0].substring(prefix.length() + 1)) + "()" : String.valueOf(repl[0]) + "()";
            String dispStr = String.valueOf(repl[0]) + "(" + repl[1] + ")";
            ContextInformation ci = null;
            if (repl[1].length() != 0) {
                ci = new ContextInformation(repl[1], repl[1]);
            }
            int cursorPosition = replStr.length() - 1;
            if (this.tester.containsKey(repl)) continue;
            this.proposals.add(new CompletionProposal(replStr, offset, compLength, cursorPosition, JsPluginImages.get("function.gif"), dispStr, (IContextInformation)ci, "function from opened files"));
            this.tester.put(repl[0], "");
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String text = viewer.getDocument().get();
        if (documentOffset < text.length() && text.charAt(documentOffset - 1) == '.' && Character.isJavaIdentifierPart(text.charAt(documentOffset))) {
            return null;
        }
        ICompletionProposal[] result = null;
        int start = TextSearchUtils.getStart2(text, documentOffset);
        int end = documentOffset;
        if (start == -1) {
            return null;
        }
        String string = text.substring(start, end).trim();
        if (string.length() == 0) {
            return null;
        }
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dwindow.getActivePage();
        IEditorInput iei = page.getActiveEditor().getEditorInput();
        if (!(iei instanceof FileEditorInput)) {
            return new ICompletionProposal[0];
        }
        FileEditorInput fei = (FileEditorInput)iei;
        this.file = fei.getFile();
        String[] completionPath = string.split("\\.", -1);
        int dotix = string.indexOf(46);
        boolean dot = dotix != -1;
        int offset = string.charAt(0) == '.' ? start + 1 : start;
        String prefix = "";
        String rest = "";
        if (dot) {
            prefix = completionPath[completionPath.length - 2];
            rest = completionPath[completionPath.length - 1];
            if (prefix.equals("this")) {
                result = this.fThisCompletionProcessor.computeCompletionProposals((JsDocument)viewer.getDocument(), documentOffset, this.file.getProject().getName(), rest);
                if (result == null) {
                    return null;
                }
            } else if (prefix.trim().length() != 0) {
                String classPrefix = ContentAssistTools.getClassFor(viewer.getDocument(), documentOffset, prefix);
                if (classPrefix.equals(prefix)) {
                    result = JSStaticCompletions.getInstance().getCompletionsFor(this.file.getProject().getName(), completionPath, documentOffset);
                } else {
                    String[] classPath = classPrefix.split("\\.");
                    String[] wholePath = new String[classPath.length + 1];
                    System.arraycopy(classPath, 0, wholePath, 0, classPath.length);
                    wholePath[wholePath.length - 1] = rest;
                    result = JSStaticCompletions.getInstance().getCompletionsFor(this.file.getProject().getName(), wholePath, documentOffset);
                }
                if (result == null || this.fstore.getBoolean("showObjectMembers")) {
                    ICompletionProposal[] objectResult = JSStaticCompletions.getInstance().getCompletionsFor(this.file.getProject().getName(), new String[]{"Object", rest}, documentOffset);
                    if (result == null) {
                        result = new CompletionProposal[]{};
                    }
                    if (objectResult == null) {
                        objectResult = new CompletionProposal[]{};
                    }
                    CompletionProposal[] extendedResult = new CompletionProposal[result.length + objectResult.length];
                    System.arraycopy(result, 0, extendedResult, 0, result.length);
                    System.arraycopy(objectResult, 0, extendedResult, result.length, objectResult.length);
                    result = extendedResult;
                }
            }
        } else {
            prefix = completionPath[0];
        }
        if (result == null) {
            int i = 0;
            while (i < completionPath.length - 2) {
                if (completionPath[i].trim().length() != 0) {
                    offset += completionPath[i].length() + 1;
                }
                ++i;
            }
            if (prefix.trim().length() == 0 && rest.trim().length() == 0) {
                return null;
            }
            result = this.getFileCompletionsFor(text, prefix, rest, offset, dot);
        }
        ICPcompare c = new ICPcompare();
        Arrays.sort(result, c);
        if (dot) {
            return result;
        }
        ICompletionProposal[] templates = this.templateComputeCompletionProposals(viewer, documentOffset);
        if (result == null) {
            return templates;
        }
        if (templates == null) {
            return result;
        }
        ICompletionProposal[] all = new ICompletionProposal[result.length + templates.length];
        System.arraycopy(templates, 0, all, 0, templates.length);
        System.arraycopy(result, 0, all, templates.length, result.length);
        return all;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected String extractIndent(ITextViewer viewer, int offset) {
        block2: {
            i = offset;
            document = viewer.getDocument();
            if (i <= document.getLength()) ** GOTO lbl7
            return "";
            {
                while ((ch = document.getChar(i - 1)) == ' ' || ch == '\t') {
                    --i;
lbl7:
                    // 2 sources

                    if (i > 0) continue;
                }
                if (i <= 0 || document.getChar(i - 1) != '\n' && document.getChar(i - 1) != '\r') break block2;
                return document.get(i, offset - i);
            }
        }
        return "";
    }

    private Template prepareTemplate(Template template, String indent) {
        if (indent.length() == 0) {
            return template;
        }
        String newPattern = template.getPattern();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < newPattern.length() - 1) {
            char c = newPattern.charAt(i);
            char next = newPattern.charAt(i + 1);
            if ((c == '\n' || c == '\r') && next != '\n' && next != '\r') {
                sb.append(c).append(indent);
            } else {
                sb.append(c);
            }
            ++i;
        }
        sb.append(newPattern.charAt(i));
        newPattern = sb.toString();
        Template t = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), newPattern, template.isAutoInsertable());
        return t;
    }

    private ICompletionProposal[] templateComputeCompletionProposals(ITextViewer viewer, int offset) {
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        String prefix = this.extractPrefix(viewer, offset);
        String indent = this.extractIndent(viewer, offset - prefix.length());
        Region region = new Region(offset - prefix.length(), prefix.length());
        TemplateContext context = this.createContext(viewer, (IRegion)region);
        if (context == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block6: {
                Template template = this.prepareTemplate(templates[i], indent);
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block6;
                }
                if (template.getName().startsWith(prefix)) {
                    matches.add(this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected Template[] getTemplates(String contextTypeId) {
        return JavaScriptEditorPlugin.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return JavaScriptEditorPlugin.getDefault().getContextTypeRegistry().getContextType("com.interaktonline.jseclipse.template.context");
    }

    protected Image getImage(Template template) {
        return JsPluginImages.get("template_obj.gif");
    }

    private class ICPcompare
    implements Comparator {
        private ICPcompare() {
        }

        public int compare(Object o1, Object o2) {
            ICompletionProposal a1 = (ICompletionProposal)o1;
            ICompletionProposal a2 = (ICompletionProposal)o2;
            return a1.getDisplayString().compareTo(a2.getDisplayString());
        }
    }
}

