/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.dialogs;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddLibraryDialog
extends Dialog {
    private Text filename;
    private String fileName;
    private Button browseButton;

    public AddLibraryDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.filename = new Text(composite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        this.filename.setLayoutData((Object)gd);
        this.filename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddLibraryDialog.this.fileName = AddLibraryDialog.this.filename.getText();
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddLibraryDialog.this.handleBrowseSelected();
            }
        });
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add library");
    }

    protected void handleBrowseSelected() {
        IDialogSettings settings = JavaScriptEditorPlugin.getDefault().getDialogSettings();
        String[] filterExtensions = new String[]{"*.xml"};
        String[] filterNames = new String[]{"JSEclipse libraries"};
        String oldPath = settings.get("LibraryPath");
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("JSEclipse libraries");
        fileDialog.setFileName(oldPath);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setFilterNames(filterNames);
        String path = fileDialog.open();
        if (path == null) {
            return;
        }
        this.filename.setText(path);
        this.fileName = path;
        settings.put("LibraryPath", this.fileName);
    }

    protected void okPressed() {
        super.okPressed();
        if (this.fileName.trim().length() == 0) {
            return;
        }
        IPath loc = JavaScriptEditorPlugin.getDefault().getStateLocation();
        String path = String.valueOf(loc.toString()) + "/user_library/";
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File src = new File(this.fileName);
        File dest = new File(String.valueOf(path) + src.getName());
        try {
            FileTools.copy(src, dest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

