/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.dialogs;

import com.interaktonline.core.text.StringUtils;
import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.util.JsPluginImages;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RegisterJSEclipseDialog
extends Dialog {
    private Text lkey;
    private Text luser;
    private String key;
    private String user;
    private Button browseButton;
    private String errorMessage = null;
    private boolean ok = false;

    public RegisterJSEclipseDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 4);
        label.setImage(JsPluginImages.get("JSEclipse_h50.gif"));
        GridData gd = new GridData(16384, 1, false, true);
        gd.widthHint = 60;
        label.setLayoutData((Object)gd);
        boolean iscom = JavaScriptEditorPlugin.getDefault().getPreferenceStore().getBoolean("com.interaktonline.jseclipse");
        if (iscom) {
            Link link = new Link(composite, 4);
            link.setText("This copy of JSEclipse is a registered commercial version.\n\nThank you,\nInterAKT Online");
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.widthHint = 400;
            link.setLayoutData((Object)gd);
        } else {
            Link link = new Link(composite, 4);
            link.setText("Register the product using a commercial key.\n\nTo register the product you will have to insert in the text fields belowthe product key that can be obtained from InterAKT site (it is written beside the license you have acquired, inside your account at InterAKT) and the user name from the InterAKT site.\n");
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.widthHint = 400;
            link.setLayoutData((Object)gd);
            label = new Label(composite, 4);
            label.setText("Product key: ");
            gd = new GridData(131072, 0x1000000, false, true);
            gd.widthHint = 100;
            label.setLayoutData((Object)gd);
            this.lkey = new Text(composite, 2052);
            gd = new GridData(768);
            gd.widthHint = 200;
            this.lkey.setLayoutData((Object)gd);
            this.lkey.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RegisterJSEclipseDialog.this.key = RegisterJSEclipseDialog.this.lkey.getText();
                }
            });
            label = new Label(composite, 4);
            label.setText("User name: ");
            gd = new GridData(131072, 0x1000000, false, true);
            gd.widthHint = 100;
            label.setLayoutData((Object)gd);
            this.luser = new Text(composite, 2052);
            gd = new GridData(768);
            gd.widthHint = 200;
            this.luser.setLayoutData((Object)gd);
            this.luser.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RegisterJSEclipseDialog.this.user = RegisterJSEclipseDialog.this.luser.getText();
                }
            });
            this.browseButton = new Button(composite, 131080);
            this.browseButton.setText("Register...");
            gd = new GridData(2);
            gd.horizontalSpan = 2;
            this.browseButton.setLayoutData((Object)gd);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RegisterJSEclipseDialog.this.handleRegister();
                }
            });
        }
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Register JSEclipse");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void handleRegister() {
        this.ok = false;
        RegistrationJob job = new RegistrationJob("Registration...");
        job.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (RegisterJSEclipseDialog.access$9(4.access$0(this.this$1))) {
                            RegisterJSEclipseDialog.access$10(4.access$0(this.this$1));
                        } else if (RegisterJSEclipseDialog.access$11(4.access$0(this.this$1)) != null) {
                            RegisterJSEclipseDialog.access$12(4.access$0(this.this$1));
                        } else {
                            RegisterJSEclipseDialog.access$13(4.access$0(this.this$1));
                        }
                    }
                });
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }

            static /* synthetic */ RegisterJSEclipseDialog access$0(4 var0) {
                return var0.RegisterJSEclipseDialog.this;
            }
        });
        job.schedule();
    }

    private void registrationOK() {
        JavaScriptEditorPlugin.getDefault().getPreferenceStore().setValue("com.interaktonline.jseclipse", true);
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Registration success", (String)"Thank you for registering your JSEclipse copy.");
    }

    private void registrationCanceled() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Registration canceled", (String)this.errorMessage);
    }

    private void registrationFailed() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Registration has failed", (String)"Registration has failed. The email address or the registration key were wrong.");
    }

    static /* synthetic */ boolean access$9(RegisterJSEclipseDialog registerJSEclipseDialog) {
        return registerJSEclipseDialog.ok;
    }

    static /* synthetic */ void access$10(RegisterJSEclipseDialog registerJSEclipseDialog) {
        registerJSEclipseDialog.registrationOK();
    }

    static /* synthetic */ String access$11(RegisterJSEclipseDialog registerJSEclipseDialog) {
        return registerJSEclipseDialog.errorMessage;
    }

    static /* synthetic */ void access$12(RegisterJSEclipseDialog registerJSEclipseDialog) {
        registerJSEclipseDialog.registrationCanceled();
    }

    static /* synthetic */ void access$13(RegisterJSEclipseDialog registerJSEclipseDialog) {
        registerJSEclipseDialog.registrationFailed();
    }

    private class RegistrationJob
    extends Job {
        public RegistrationJob(String name) {
            super(name);
        }

        private boolean isTheUser(String userAsMD5) {
            try {
                String theMD5 = StringUtils.getHashText(RegisterJSEclipseDialog.this.user, "MD5");
                return theMD5.equals(userAsMD5);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return false;
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                String line;
                String data = String.valueOf(URLEncoder.encode("key", "UTF-8")) + "=" + URLEncoder.encode(RegisterJSEclipseDialog.this.key, "UTF-8");
                URL url = new URL("http://www.interaktonline.com/activation/JSEclipse/index.php?from=eclipse&" + data);
                BufferedReader rd = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuffer sb = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
                RegisterJSEclipseDialog.this.ok = this.isTheUser(sb.toString());
            }
            catch (Exception e) {
                RegisterJSEclipseDialog.this.errorMessage = "Connection problem. Server is not reachable or proxy is not set in Eclipse.";
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }
}

