/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors;

import com.interaktonline.jseclipse.actions.utils.GotoMatchingBracket;
import com.interaktonline.jseclipse.text.TextUtilities;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class BracketMatcher
implements ICharacterPairMatcher {
    private int fOffset;
    private int fEndPos;
    private int fAnchor;
    private IDocument fDocument;
    private static GotoMatchingBracket matcher;

    public BracketMatcher() {
        if (matcher == null) {
            matcher = new GotoMatchingBracket();
        }
    }

    public void dispose() {
        matcher = null;
    }

    public void clear() {
    }

    public IRegion match(IDocument iDocument, int i) {
        this.fOffset = i;
        if (this.fOffset <= 0) {
            return null;
        }
        this.fDocument = iDocument;
        if (this.fDocument == null) {
            return null;
        }
        if (!TextUtilities.isPartition(this.fDocument, i - 1, "__dftl_partition_content_type")) {
            return null;
        }
        this.fEndPos = matcher.getPair(this.fDocument, this.fOffset);
        if (this.fEndPos == -1) {
            return null;
        }
        this.fAnchor = this.fOffset < this.fEndPos ? 0 : 1;
        return new Region(this.fEndPos, 1);
    }

    public int getAnchor() {
        return this.fAnchor;
    }
}

