/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class JSColorProvider {
    public static final RGB POPUP_BG = new RGB(255, 255, 255);
    protected Map fColorTable = new HashMap(16);
    protected Map fTokenTable = new HashMap(16);
    protected IPreferenceStore store;

    public JSColorProvider(IPreferenceStore store) {
        this.store = store;
    }

    public void dispose() {
        Iterator it = this.fColorTable.values().iterator();
        while (it.hasNext()) {
            Color i = (Color)it.next();
            i.dispose();
        }
    }

    public Color getColor(String preferanceKey) {
        String colorName = this.store.getString(preferanceKey);
        RGB rgb = StringConverter.asRGB((String)colorName);
        return this.getColor(rgb);
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public IToken getToken(String prefKey) {
        Token token = (Token)this.fTokenTable.get(prefKey);
        if (token == null) {
            String colorName = this.store.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            token = new Token((Object)new TextAttribute(this.getColor(rgb)));
            this.fTokenTable.put(prefKey, token);
        }
        return token;
    }

    public IToken getBoldToken(String prefKey) {
        Token token = (Token)this.fTokenTable.get(prefKey);
        if (token == null) {
            String colorName = this.store.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            token = new Token((Object)new TextAttribute(this.getColor(rgb), null, 1));
            this.fTokenTable.put(prefKey, token);
        }
        return token;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        Token token = (Token)this.fTokenTable.get(event.getProperty());
        return token != null;
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String prefKey = event.getProperty();
        Token token = (Token)this.fTokenTable.get(prefKey);
        if (token != null) {
            String colorName = this.store.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            TextAttribute ta = (TextAttribute)token.getData();
            token.setData((Object)new TextAttribute(this.getColor(rgb), null, ta.getStyle()));
        }
    }
}

