/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.contentassist.HtmlIdCompletionProcessor;
import com.interaktonline.jseclipse.contentassist.JSCompletionProcessor;
import com.interaktonline.jseclipse.contentassist.JavaDocCompletionProcessor;
import com.interaktonline.jseclipse.editors.JSAnnotationHover;
import com.interaktonline.jseclipse.editors.JSColorProvider;
import com.interaktonline.jseclipse.editors.JSDoubleClickStrategy;
import com.interaktonline.jseclipse.library.HtmlLibraryManager;
import com.interaktonline.jseclipse.library.JsLibraryManager;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class JSConfiguration
extends SourceViewerConfiguration {
    private static boolean parsed = false;
    private IPreferenceStore fPreferenceStore;
    private JSDoubleClickStrategy doubleClickStrategy;

    public JSConfiguration(IPreferenceStore preferenceStore) {
        this.fPreferenceStore = preferenceStore;
        if (!parsed) {
            JsLibraryManager.getInstance().parseDynamicLibrary();
            HtmlLibraryManager.getInstance().parseDynamicLibrary();
            parsed = true;
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_javadoc", "__javascript_string", "__javascript_regexp", "__javascript_singleline_comment", "__javascript_multiline_comment"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new JSDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.fPreferenceStore.getInt("tabWidth");
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        ArrayList<String> list = new ArrayList<String>();
        int tabWidth = this.getTabWidth(sourceViewer);
        boolean useSpaces = this.fPreferenceStore.getBoolean("spaces4tab");
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            list.add(prefix.toString());
            ++i;
        }
        list.add("");
        return list.toArray(new String[list.size()]);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        JSColorProvider provider = JavaScriptEditorPlugin.getDefault().getJSColorProvider(this.fPreferenceStore);
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setContentAssistProcessor((IContentAssistProcessor)new JSCompletionProcessor(), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new HtmlIdCompletionProcessor(), "__javascript_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new JavaDocCompletionProcessor(), "__java_javadoc");
        assistant.setProposalSelectorBackground(provider.getColor(JSColorProvider.POPUP_BG));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(this.fPreferenceStore.getInt("assistdelay"));
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(provider.getColor(JSColorProvider.POPUP_BG));
        assistant.enableAutoInsert(true);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        JSColorProvider provider = JavaScriptEditorPlugin.getDefault().getJSColorProvider(this.fPreferenceStore);
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)JavaScriptEditorPlugin.getDefault().getJSCodeScanner(this.fPreferenceStore));
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)JavaScriptEditorPlugin.getDefault().getJSSinglelineCommentScanner(this.fPreferenceStore));
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)JavaScriptEditorPlugin.getDefault().getJSDocScanner(this.fPreferenceStore));
        reconciler.setDamager((IPresentationDamager)dr, "__java_javadoc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_javadoc");
        dr = new DefaultDamagerRepairer((ITokenScanner)JavaScriptEditorPlugin.getDefault().getJSMultilineCommentScanner(this.fPreferenceStore));
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(provider.getColor("stringColor"))));
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(provider.getColor("regexpColor"))));
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_regexp");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_regexp");
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new JSAnnotationHover();
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

