/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors;

import com.interaktonline.jseclipse.editors.JSColorProvider;
import com.interaktonline.jseclipse.editors.JSWhitespaceDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JavaDocScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"@author", "@deprecated", "@exception", "@param", "@return", "@see", "@serial", "@serialData", "@serialField", "@since", "@throws", "@version", "@constructor", "@argument", "@requires", "@link", "@fileoverview", "@class", "@type", "@extends", "@private", "@final", "@member", "@ignore", "@base", "@exec"};

    public JavaDocScanner(JSColorProvider provider) {
        this.setDefaultReturnToken(provider.getToken("javadocDefaultColor"));
        IToken keyword = provider.getToken("javadocKeywordColor");
        IToken tag2 = provider.getToken("javadocTagColor");
        IToken link = provider.getToken("javadocLinkColor");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new SingleLineRule("<", ">", tag2));
        list.add(new SingleLineRule("{@link", "}", link));
        list.add(new WhitespaceRule((IWhitespaceDetector)new JSWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JavaDocWordDetector());
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], keyword);
            ++i;
        }
        list.add(wordRule);
        IRule[] result = new IRule[list.size()];
        list.toArray(result);
        this.setRules(result);
    }

    private static class JavaDocWordDetector
    implements IWordDetector {
        private JavaDocWordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }
}

