/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.Messages;
import com.interaktonline.jseclipse.actions.CodeCommentAction;
import com.interaktonline.jseclipse.actions.GoToMatchingBracketAction;
import com.interaktonline.jseclipse.actions.OpenDeclarationAction;
import com.interaktonline.jseclipse.actions.SelectToMatchingBracketAction;
import com.interaktonline.jseclipse.editors.BracketMatcher;
import com.interaktonline.jseclipse.editors.JSColorProvider;
import com.interaktonline.jseclipse.editors.JSConfiguration;
import com.interaktonline.jseclipse.editors.JSDocumentProvider;
import com.interaktonline.jseclipse.editors.JsInformationPresenter;
import com.interaktonline.jseclipse.editors.OccurrenceMarkerJobStarter;
import com.interaktonline.jseclipse.editors.externals.ExternalManagementEvent;
import com.interaktonline.jseclipse.editors.externals.IExternalManagementListener;
import com.interaktonline.jseclipse.preferences.PreferenceConstants;
import com.interaktonline.jseclipse.text.BlockAutoEditStrategy;
import com.interaktonline.jseclipse.text.CommentAutoEditStrategy;
import com.interaktonline.jseclipse.text.JavaDocAutoEditStrategy;
import com.interaktonline.jseclipse.text.JavascriptAutoEditStrategy;
import com.interaktonline.jseclipse.text.LanguageConstants;
import com.interaktonline.jseclipse.text.ParserPartListener;
import com.interaktonline.jseclipse.text.StringAutoEditStrategy;
import com.interaktonline.jseclipse.text.TextUtilities;
import com.interaktonline.jseclipse.text.folding.IFoldingStructureProvider;
import com.interaktonline.jseclipse.text.folding.JSFoldingStructureProvider;
import com.interaktonline.jseclipse.views.contentoutline.JsContentOutlineView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;

public class JsEditor
extends TextEditor {
    public static String ID = "com.interaktonline.jseclipse.editors.JsEditor";
    private static String CHR_PAIR = "CharacterPair";
    private boolean spaces_4_tab = false;
    private int tabWidth;
    private static String tabAsString = "";
    private boolean fIsWordwrapModeEnabled;
    private final String fWordWrapLabel = Messages.getString("WordWrap.on");
    private final String fNoWordWrapLabel = Messages.getString("WordWrap.off");
    private JSColorProvider colorManager;
    private JsContentOutlineView fOutlinePage;
    private ICharacterPairMatcher fBracketMatcher;
    private ProjectionSupport fProjectionSupport;
    private IFoldingStructureProvider fProjectionModelUpdater;
    private InformationPresenter fInformationPresenter;
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    private boolean external = false;
    private List externalManagementListeners;
    private boolean fMarkOccurrenceAnnotations;
    private Annotation[] fOccurrenceAnnotations = null;
    private OccurrencesMarkerJob fOccurrencesMarkerJob;
    private LanguageConstants fLanguageConstants;
    private CharPairCloser fCharPairCloser;
    private boolean fAutoEdit = true;
    private IAutoEditStrategy fCommentAutoEditStrategy;
    private IAutoEditStrategy fJavaDocAutoEditStrategy;
    private IAutoEditStrategy fMultilineCommentAutoEditStrategy;
    private IAutoEditStrategy fStringAutoEditStrategy;
    private IAutoEditStrategy fBlockAutoEditStrategy;
    private boolean toMark = false;
    private OccurrenceMarkerJobStarter fOccurrenceMarkerJobStarter = null;
    static /* synthetic */ Class class$0;

    public JsEditor() {
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), JavaScriptEditorPlugin.getDefault().getPreferenceStore()}));
        JSConfiguration configuration = new JSConfiguration(this.getPreferenceStore());
        this.colorManager = JavaScriptEditorPlugin.getDefault().getJSColorProvider(this.getPreferenceStore());
        this.fBracketMatcher = new BracketMatcher();
        this.setDocumentProvider((IDocumentProvider)new JSDocumentProvider());
        this.setSourceViewerConfiguration(configuration);
        this.spaces_4_tab = this.getPreferenceStore().getBoolean("spaces4tab");
        this.tabWidth = this.getPreferenceStore().getInt("tabWidth");
        tabAsString = "                              ".substring(0, this.tabWidth);
        this.fMarkOccurrenceAnnotations = this.getPreferenceStore().getBoolean("markOccurrences");
        this.fLanguageConstants = LanguageConstants.getInstance();
    }

    public void dispose() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).removeVerifyKeyListener((VerifyKeyListener)this.fCharPairCloser);
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fOccurrencesMarkerJob != null) {
            this.fOccurrencesMarkerJob.dispose();
            this.fOccurrencesMarkerJob = null;
        }
        this.fOutlinePage = null;
        this.colorManager = null;
        this.fBracketMatcher = null;
        this.stopAutoEdit();
        if (this.isExternal()) {
            this.fireExternalCloseEvent();
        }
        super.dispose();
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setCarretOffset(int offset) {
        this.getSourceViewer().getTextWidget().setCaretOffset(offset);
    }

    public void addExternalManagementListener(IExternalManagementListener listener) {
        if (this.externalManagementListeners == null) {
            this.externalManagementListeners = new ArrayList();
        }
        this.externalManagementListeners.add(listener);
    }

    public void removeExternalManagementListener(IExternalManagementListener listener) {
        if (this.externalManagementListeners == null) {
            return;
        }
        this.externalManagementListeners.remove(listener);
    }

    private void fireExternalSaveEvent() {
        ExternalManagementEvent event = new ExternalManagementEvent((Object)this);
        Iterator it = this.externalManagementListeners.iterator();
        while (it.hasNext()) {
            IExternalManagementListener listener = (IExternalManagementListener)it.next();
            listener.isSaving(event);
        }
    }

    private void fireExternalCloseEvent() {
        ExternalManagementEvent event = new ExternalManagementEvent((Object)this);
        Iterator it = this.externalManagementListeners.iterator();
        while (it.hasNext()) {
            IExternalManagementListener listener = (IExternalManagementListener)it.next();
            listener.isClosing(event);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ParserPartListener.getInstance(this.getSite().getPage());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shellParent) {
                return new DefaultInformationControl(shellParent);
            }
        });
        this.fProjectionSupport.install();
        this.fProjectionModelUpdater = new JSFoldingStructureProvider();
        this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
        projectionViewer.doOperation(19);
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 16, style, (DefaultInformationControl.IInformationPresenter)new JsInformationPresenter());
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        StyledText widget = projectionViewer.getTextWidget();
        widget.addVerifyListener((VerifyListener)new Spaces_4_tab_listener());
        ISourceViewer viewer = this.getSourceViewer();
        this.fCharPairCloser = new CharPairCloser();
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).prependVerifyKeyListener((VerifyKeyListener)this.fCharPairCloser);
        }
        if (this.isAutoEditEnabled()) {
            this.resetAutoEdit();
        }
    }

    protected boolean isAutoEditEnabled() {
        return this.fAutoEdit;
    }

    private void resetAutoEdit() {
        if (this.spaces_4_tab) {
            JavascriptAutoEditStrategy.indentString = tabAsString;
        }
        SourceViewer lSourceViewer = (SourceViewer)this.getSourceViewer();
        boolean auto = this.getPreferenceStore().getBoolean("stringTypingAssist");
        if (auto) {
            if (this.fStringAutoEditStrategy == null) {
                this.fStringAutoEditStrategy = new StringAutoEditStrategy();
                lSourceViewer.prependAutoEditStrategy(this.fStringAutoEditStrategy, "__javascript_string");
            }
        } else if (this.fStringAutoEditStrategy != null) {
            lSourceViewer.removeAutoEditStrategy(this.fStringAutoEditStrategy, "__javascript_string");
            this.fStringAutoEditStrategy = null;
        }
        if (auto = this.getPreferenceStore().getBoolean("bracesTypingAssist")) {
            if (this.fBlockAutoEditStrategy == null) {
                this.fBlockAutoEditStrategy = new BlockAutoEditStrategy();
                lSourceViewer.prependAutoEditStrategy(this.fBlockAutoEditStrategy, "__dftl_partition_content_type");
            }
        } else if (this.fBlockAutoEditStrategy != null) {
            lSourceViewer.removeAutoEditStrategy(this.fBlockAutoEditStrategy, "__dftl_partition_content_type");
            this.fBlockAutoEditStrategy = null;
        }
        if (auto = this.getPreferenceStore().getBoolean("javadocTypingAssist")) {
            if (this.fCommentAutoEditStrategy == null) {
                this.fCommentAutoEditStrategy = new CommentAutoEditStrategy();
                lSourceViewer.prependAutoEditStrategy(this.fCommentAutoEditStrategy, "__javascript_singleline_comment");
            }
            if (this.fJavaDocAutoEditStrategy == null) {
                this.fJavaDocAutoEditStrategy = new JavaDocAutoEditStrategy();
                lSourceViewer.prependAutoEditStrategy(this.fJavaDocAutoEditStrategy, "__java_javadoc");
            }
            if (this.fMultilineCommentAutoEditStrategy == null) {
                this.fMultilineCommentAutoEditStrategy = new JavaDocAutoEditStrategy();
                lSourceViewer.prependAutoEditStrategy(this.fMultilineCommentAutoEditStrategy, "__javascript_multiline_comment");
            }
        } else {
            if (this.fCommentAutoEditStrategy != null) {
                lSourceViewer.removeAutoEditStrategy(this.fCommentAutoEditStrategy, "__java_javadoc");
                this.fCommentAutoEditStrategy = null;
            }
            if (this.fJavaDocAutoEditStrategy != null) {
                lSourceViewer.removeAutoEditStrategy(this.fJavaDocAutoEditStrategy, "__java_javadoc");
                this.fJavaDocAutoEditStrategy = null;
            }
            if (this.fMultilineCommentAutoEditStrategy != null) {
                lSourceViewer.removeAutoEditStrategy(this.fMultilineCommentAutoEditStrategy, "__javascript_multiline_comment");
                this.fMultilineCommentAutoEditStrategy = null;
            }
        }
    }

    private void stopAutoEdit() {
        SourceViewer lSourceViewer = (SourceViewer)this.getSourceViewer();
        if (this.fCommentAutoEditStrategy != null) {
            lSourceViewer.removeAutoEditStrategy(this.fCommentAutoEditStrategy, "__java_javadoc");
            this.fCommentAutoEditStrategy = null;
        }
        if (this.fJavaDocAutoEditStrategy != null) {
            lSourceViewer.removeAutoEditStrategy(this.fJavaDocAutoEditStrategy, "__java_javadoc");
            this.fJavaDocAutoEditStrategy = null;
        }
        if (this.fMultilineCommentAutoEditStrategy != null) {
            lSourceViewer.removeAutoEditStrategy(this.fMultilineCommentAutoEditStrategy, "__javascript_multiline_comment");
            this.fMultilineCommentAutoEditStrategy = null;
        }
        if (this.fStringAutoEditStrategy != null) {
            lSourceViewer.removeAutoEditStrategy(this.fStringAutoEditStrategy, "__javascript_string");
            this.fStringAutoEditStrategy = null;
        }
        if (this.fBlockAutoEditStrategy != null) {
            lSourceViewer.removeAutoEditStrategy(this.fBlockAutoEditStrategy, "__dftl_partition_content_type");
            this.fBlockAutoEditStrategy = null;
        }
    }

    public void updateOccurrences() {
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        try {
            ITypedRegion region = document.getPartition(selection.getOffset());
            if (!region.getType().equals("__dftl_partition_content_type")) {
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (this.fOccurrencesMarkerJob == null) {
            this.fOccurrencesMarkerJob = new OccurrencesMarkerJob(document);
        }
        this.fOccurrencesMarkerJob.setSelection(selection);
        this.fOccurrencesMarkerJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        IAnnotationModel iAnnotationModel = annotationModel;
        synchronized (iAnnotationModel) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void createActions() {
        super.createActions();
        Object a = new TextOperationAction(Messages.getBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new OpenDeclarationAction(Messages.getBundle(), "OpenDeclaration.", (ITextEditor)this, 22, (ITextViewer)this.getSourceViewer());
        this.setAction("OpenDeclaration", (IAction)a);
        a = new CodeCommentAction(Messages.getBundle(), "CodeComment.", (ITextEditor)this, 22, (ITextViewer)this.getSourceViewer());
        this.setAction("CodeComment", (IAction)a);
        a = new GoToMatchingBracketAction(Messages.getBundle(), "GotoMatchingBracket.", (ITextEditor)this, 22, (ITextViewer)this.getSourceViewer());
        this.setAction("GotoMatchingBracket", (IAction)a);
        a = new SelectToMatchingBracketAction(Messages.getBundle(), "SelecttoMatchingBracket.", (ITextEditor)this, 22, (ITextViewer)this.getSourceViewer());
        this.setAction("SelecttoMatchingBracket", (IAction)a);
        a = new TextOperationAction(Messages.getBundle(), "FormatCode.", (ITextEditor)this, 15);
        a.setActionDefinitionId("com.interaktonline.jseclipse.editors.formatCode");
        this.setAction("FormatCode", (IAction)a);
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        ToggleWordWrapModeAction action = new ToggleWordWrapModeAction(Messages.getBundle(), "WordWrap.");
        action.setActionDefinitionId("com.interaktonline.jseclipse.toggleWordwrap");
        this.setAction("com.interaktonline.jseclipse.toggleWordwrap", (IAction)action);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "ContentAssistProposal");
        this.addAction(menu, "OpenDeclaration");
        IAction formatAction = this.getAction("FormatCode");
        if (formatAction == null) {
            return;
        }
        if (formatAction.isEnabled()) {
            menu.add(formatAction);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block8: {
            block7: {
                try {
                    if (event.getProperty().equals("spaces4tab")) {
                        this.spaces_4_tab = this.getPreferenceStore().getBoolean("spaces4tab");
                        JavascriptAutoEditStrategy.indentString = this.spaces_4_tab ? tabAsString : "\t";
                        Object var2_2 = null;
                        break block7;
                    }
                    if (event.getProperty().equals("tabWidth")) {
                        this.tabWidth = this.getPreferenceStore().getInt("tabWidth");
                        JavascriptAutoEditStrategy.indentString = tabAsString = "                              ".substring(0, this.tabWidth);
                    }
                    if (event.getProperty().equals("markOccurrences")) {
                        this.fMarkOccurrenceAnnotations = this.getPreferenceStore().getBoolean("markOccurrences");
                        this.removeOccurrenceAnnotations();
                        this.updateOccurrences();
                    }
                    if (PreferenceConstants.isTypingPreference(event.getProperty())) {
                        this.resetAutoEdit();
                    }
                    this.colorManager.handlePreferenceStoreChanged(event);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    super.handlePreferenceStoreChanged(event);
                    throw throwable;
                }
            }
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var2_4 = null;
        super.handlePreferenceStoreChanged(event);
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (this.fOccurrenceMarkerJobStarter == null) {
            this.fOccurrenceMarkerJobStarter = OccurrenceMarkerJobStarter.getInstance();
        }
        this.toMark = true;
        this.fOccurrenceMarkerJobStarter.setEditor(this);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event) || this.colorManager.affectsTextPresentation(event);
    }

    protected void updateStatusField(String category) {
        if (category == null) {
            return;
        }
        IStatusField field = this.getStatusField(category);
        if (field != null) {
            String text = null;
            if ("WordWrap.".equals(category)) {
                text = this.isWordWrapModeEnabled() ? this.fWordWrapLabel : this.fNoWordWrapLabel;
                field.setText(text == null ? this.fErrorLabel : text);
                return;
            }
        }
        super.updateStatusField(category);
    }

    public boolean isWordWrapModeEnabled() {
        return this.fIsWordwrapModeEnabled;
    }

    public boolean isMarkOccurrenceEnabled() {
        return this.fMarkOccurrenceAnnotations;
    }

    public void setMarkOccurrence(boolean mark) {
        this.fMarkOccurrenceAnnotations = mark;
    }

    public Object getAdapter(Class required) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new JsContentOutlineView(this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    public void toggleWordWrapMode() {
        this.fIsWordwrapModeEnabled = !this.fIsWordwrapModeEnabled;
        this.getSourceViewer().getTextWidget().setWordWrap(this.fIsWordwrapModeEnabled);
        this.updateStatusField("WordWrap.");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"com.interaktonline.jseclipse.jsEditorScope"});
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher(this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected CompositeRuler createCompositeRuler() {
        return super.createCompositeRuler();
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return super.createAnnotationAccess();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
        if (this.isExternal()) {
            this.fireExternalSaveEvent();
        }
    }

    private static char getPairCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isSaveAsAllowed() {
        if (this.isExternal()) {
            return false;
        }
        return super.isSaveAsAllowed();
    }

    public boolean isToMark() {
        return this.toMark;
    }

    public void setToMark(boolean toMark) {
        this.toMark = toMark;
    }

    class ToggleWordWrapModeAction
    extends ResourceAction {
        public ToggleWordWrapModeAction(ResourceBundle bundle, String prefix) {
            super(bundle, prefix);
        }

        public void run() {
            JsEditor.this.toggleWordWrapMode();
        }
    }

    class Spaces_4_tab_listener
    implements VerifyListener {
        Spaces_4_tab_listener() {
        }

        public void verifyText(VerifyEvent e) {
            if (JsEditor.this.spaces_4_tab && e.text.equals("\t")) {
                int pos = e.start;
                ISourceViewer textViewer = JsEditor.this.getSourceViewer();
                if (textViewer == null) {
                    return;
                }
                IDocument document = textViewer.getDocument();
                int toAdd = 0;
                try {
                    int lineStart = document.getLineOffset(document.getLineOfOffset(pos));
                    toAdd = JsEditor.this.tabWidth - (pos - lineStart) % JsEditor.this.tabWidth;
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                e.text = tabAsString.substring(0, toAdd);
            }
        }
    }

    class OccurrencesMarkerJob
    extends Job
    implements IDocumentListener {
        private IDocument fDocument;
        private boolean fCancelled = false;
        private IProgressMonitor fProgressMonitor;
        private List fPositions;
        private ITextSelection fSelection;

        public OccurrencesMarkerJob(IDocument document) {
            super("Occurrences Marker");
            this.fDocument = document;
            this.fDocument.addDocumentListener((IDocumentListener)this);
        }

        public void dispose() {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
        }

        private void setSelection(ITextSelection selection) {
            this.fSelection = selection;
        }

        private boolean isCancelled() {
            return this.fCancelled || this.fProgressMonitor.isCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            block31: {
                IStatus iStatus;
                block29: {
                    IStatus iStatus2;
                    block30: {
                        IStatus iStatus3;
                        block28: {
                            IStatus iStatus4;
                            block27: {
                                IStatus iStatus5;
                                block26: {
                                    IStatus iStatus6;
                                    block25: {
                                        IStatus iStatus7;
                                        block24: {
                                            this.fProgressMonitor = progressMonitor;
                                            try {
                                                if (this.isCancelled()) {
                                                    IStatus iStatus8 = Status.CANCEL_STATUS;
                                                    Object var12_11 = null;
                                                    this.fCancelled = false;
                                                    return iStatus8;
                                                }
                                                ISourceViewer textViewer = JsEditor.this.getSourceViewer();
                                                if (textViewer == null) {
                                                    iStatus7 = Status.CANCEL_STATUS;
                                                    break block24;
                                                }
                                                IDocument document = textViewer.getDocument();
                                                if (document == null) {
                                                    iStatus6 = Status.CANCEL_STATUS;
                                                    break block25;
                                                }
                                                IDocumentProvider documentProvider = JsEditor.this.getDocumentProvider();
                                                if (documentProvider == null) {
                                                    iStatus5 = Status.CANCEL_STATUS;
                                                    break block26;
                                                }
                                                IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)JsEditor.this.getEditorInput());
                                                if (annotationModel == null) {
                                                    iStatus4 = Status.CANCEL_STATUS;
                                                    break block27;
                                                }
                                                try {
                                                    if (this.isCancelled()) {
                                                        iStatus3 = Status.CANCEL_STATUS;
                                                        break block28;
                                                    }
                                                }
                                                catch (BadLocationException badLocationException) {
                                                    IStatus iStatus9 = Status.CANCEL_STATUS;
                                                    Object var12_17 = null;
                                                    this.fCancelled = false;
                                                    return iStatus9;
                                                }
                                                {
                                                    this.fPositions = this.getOccurrences(document);
                                                }
                                                int length = this.fPositions.size();
                                                HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
                                                Iterator it = this.fPositions.iterator();
                                                while (true) {
                                                    String message;
                                                    if (!it.hasNext()) {
                                                        if (!this.isCancelled()) break;
                                                        iStatus = Status.CANCEL_STATUS;
                                                        break block29;
                                                    }
                                                    Position position = (Position)it.next();
                                                    if (this.isCancelled()) {
                                                        iStatus2 = Status.CANCEL_STATUS;
                                                        break block30;
                                                    }
                                                    try {
                                                        message = document.get(position.offset, position.length);
                                                    }
                                                    catch (BadLocationException badLocationException) {
                                                        continue;
                                                    }
                                                    annotationMap.put(new Annotation("com.interaktonline.jseclipse.ui.occurrences", false, message), position);
                                                }
                                                IAnnotationModel iAnnotationModel = annotationModel;
                                                synchronized (iAnnotationModel) {
                                                    if (annotationModel instanceof IAnnotationModelExtension) {
                                                        ((IAnnotationModelExtension)annotationModel).replaceAnnotations(JsEditor.this.fOccurrenceAnnotations, annotationMap);
                                                    } else {
                                                        JsEditor.this.removeOccurrenceAnnotations();
                                                        Iterator iter = annotationMap.entrySet().iterator();
                                                        while (iter.hasNext()) {
                                                            Map.Entry mapEntry = iter.next();
                                                            annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                                                        }
                                                    }
                                                    JsEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
                                                    break block31;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var12_20 = null;
                                                this.fCancelled = false;
                                                throw throwable;
                                            }
                                        }
                                        Object var12_12 = null;
                                        this.fCancelled = false;
                                        return iStatus7;
                                    }
                                    Object var12_13 = null;
                                    this.fCancelled = false;
                                    return iStatus6;
                                }
                                Object var12_14 = null;
                                this.fCancelled = false;
                                return iStatus5;
                            }
                            Object var12_15 = null;
                            this.fCancelled = false;
                            return iStatus4;
                        }
                        Object var12_16 = null;
                        this.fCancelled = false;
                        return iStatus3;
                    }
                    Object var12_18 = null;
                    this.fCancelled = false;
                    return iStatus2;
                }
                Object var12_19 = null;
                this.fCancelled = false;
                return iStatus;
            }
            Object var12_21 = null;
            this.fCancelled = false;
            return Status.OK_STATUS;
        }

        private List getOccurrences(IDocument document) throws BadLocationException {
            ArrayList<Position> positions = new ArrayList<Position>();
            String text = document.get();
            int offset = this.fSelection.getOffset();
            int length = this.fSelection.getLength();
            String word = null;
            if (length != 0 && (word = document.get(offset, length)).indexOf(32) != -1) {
                return positions;
            }
            int start = offset;
            int end = offset;
            while (start > 0 && Character.isJavaIdentifierPart(text.charAt(start - 1))) {
                --start;
            }
            while (end < document.getLength() && Character.isJavaIdentifierPart(text.charAt(end))) {
                ++end;
            }
            length = end - start;
            if (length == 0) {
                return positions;
            }
            word = document.get(start, length);
            if (JsEditor.this.fLanguageConstants.isJsWord(word)) {
                return positions;
            }
            ITypedRegion[] regions = document.computePartitioning(0, document.getLength());
            int j = 0;
            while (j < regions.length) {
                ITypedRegion region = regions[j];
                if (region.getType() == "__dftl_partition_content_type") {
                    int i = region.getOffset();
                    while ((i = text.indexOf(word, i)) != -1 && i < region.getOffset() + region.getLength()) {
                        if (!(i != 0 && Character.isJavaIdentifierPart(text.charAt(i - 1)) || i + length != text.length() && Character.isJavaIdentifierPart(text.charAt(i + length)))) {
                            positions.add(new Position(i, length));
                        }
                        i += length;
                    }
                }
                ++j;
            }
            return positions;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            this.fCancelled = true;
        }

        public void documentChanged(DocumentEvent event) {
        }
    }

    class CharPairLinkedModeModel
    extends LinkedModeModel {
        Position start;
        Position end;

        CharPairLinkedModeModel() {
        }
    }

    class CharPairPositionUpdater
    implements IPositionUpdater {
        CharPairPositionUpdater() {
        }

        public void update(DocumentEvent event) {
            IDocument lDocument = event.getDocument();
            int offset = event.getOffset();
            int oldLength = event.getLength();
            int newLength = event.getText() == null ? 0 : event.getText().length();
            try {
                Position[] charPairPositions = lDocument.getPositions(CHR_PAIR);
                int i = 0;
                while (i < charPairPositions.length) {
                    Position pos = charPairPositions[i];
                    if (!pos.isDeleted() && offset <= pos.offset) {
                        if (offset + oldLength >= pos.offset + pos.length) {
                            pos.isDeleted = true;
                        } else {
                            pos.offset += newLength - oldLength;
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException e) {
                e.printStackTrace();
            }
        }
    }

    class CharPairExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private char exitChar;

        public CharPairExitPolicy(char exitChar) {
            this.exitChar = exitChar;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == this.exitChar && model instanceof CharPairLinkedModeModel) {
                CharPairLinkedModeModel lModel = (CharPairLinkedModeModel)model;
                if (lModel.start.offset > offset || lModel.end.offset < offset) {
                    return null;
                }
                if (lModel.end.offset == offset && length == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }
    }

    class CharPairCloser
    implements VerifyKeyListener,
    ILinkedModeListener {
        private final ISourceViewer fSourceViewer;
        private IDocument fDocument;
        private IPositionUpdater fPositionUpdater;
        private IPreferenceStore fstore;

        public CharPairCloser() {
            this.fSourceViewer = JsEditor.this.getSourceViewer();
            this.fDocument = this.fSourceViewer.getDocument();
            this.fDocument.addPositionCategory(CHR_PAIR);
            this.fPositionUpdater = new CharPairPositionUpdater();
            this.fDocument.addPositionUpdater(this.fPositionUpdater);
            this.fstore = JsEditor.this.getPreferenceStore();
        }

        public void dispose() {
            this.fDocument.removePositionUpdater(this.fPositionUpdater);
        }

        private boolean isCharacterFrom(char[] arr, char c) {
            if (arr == null) {
                return false;
            }
            int i = 0;
            while (i < arr.length) {
                if (arr[i] == c) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isSameFollowing(IDocument document, int offset, char chr, char[] exceptions) {
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                int lineEnd = region.getOffset() + region.getLength();
                int ix = offset;
                while (ix < lineEnd && !this.isCharacterFrom(exceptions, document.getChar(ix)) && chr != document.getChar(ix)) {
                    ++ix;
                }
                return ix != lineEnd && document.getChar(ix) == chr;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return true;
            }
        }

        private boolean isIdentifierPartFollowing(IDocument document, int offset) {
            try {
                return Character.isJavaIdentifierPart(document.getChar(offset));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return true;
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit) {
                return;
            }
            Point selection = this.fSourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            switch (event.character) {
                case '\"': {
                    boolean doAutoedit = this.fstore.getBoolean("stringTypingAssist");
                    if (!doAutoedit) {
                        return;
                    }
                    if (!this.isSameFollowing(this.fDocument, offset + length, '\"', null)) break;
                    return;
                }
                case '\'': {
                    boolean doAutoedit = this.fstore.getBoolean("stringTypingAssist");
                    if (!doAutoedit) {
                        return;
                    }
                    if (!this.isSameFollowing(this.fDocument, offset + length, '\'', null)) break;
                    return;
                }
                case '(': {
                    boolean doAutoedit = this.fstore.getBoolean("paranthesesTypingAssist");
                    if (!doAutoedit) {
                        return;
                    }
                    if (!this.isSameFollowing(this.fDocument, offset + length, '(', new char[]{'.', ' ', '\t'})) break;
                    return;
                }
                case '[': {
                    boolean doAutoedit = this.fstore.getBoolean("paranthesesTypingAssist");
                    if (!doAutoedit) {
                        return;
                    }
                    if (!this.isSameFollowing(this.fDocument, offset + length, '[', new char[]{'.', ' ', '\t'})) break;
                    return;
                }
                default: {
                    return;
                }
            }
            if (this.isIdentifierPartFollowing(this.fDocument, offset + length)) {
                return;
            }
            if (!TextUtilities.isPartition(this.fDocument, offset, "__dftl_partition_content_type")) {
                return;
            }
            if (!JsEditor.this.validateEditorInputState()) {
                return;
            }
            char chr = event.character;
            char pairChr = JsEditor.getPairCharacter(chr);
            String pair = new String(new char[]{chr, pairChr});
            try {
                this.fDocument.replace(offset, length, pair);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(this.fDocument, offset + 1, 0, -1));
                CharPairLinkedModeModel model = new CharPairLinkedModeModel();
                model.addGroup(group);
                model.forceInstall();
                model.addLinkingListener(this);
                model.start = new Position(offset, 1);
                model.end = new Position(offset + 1, 1);
                this.fDocument.addPosition(CHR_PAIR, model.start);
                this.fDocument.addPosition(CHR_PAIR, model.end);
                LinkedModeUI ui = new LinkedModeUI((LinkedModeModel)model, new ITextViewer[]{this.fSourceViewer});
                ui.setExitPosition((ITextViewer)this.fSourceViewer, offset + 2, 0, -1);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new CharPairExitPolicy(pairChr));
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.setSimpleMode(true);
                ui.enter();
            }
            catch (BadPositionCategoryException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.fSourceViewer.setSelectedRange(offset + 1, 0);
            event.doit = false;
        }

        public void left(LinkedModeModel model, int flags) {
            if (flags != 8) {
                return;
            }
            CharPairLinkedModeModel lModel = (CharPairLinkedModeModel)model;
            if (this.fDocument instanceof IDocumentExtension) {
                ((IDocumentExtension)this.fDocument).registerPostNotificationReplace(null, new IDocumentExtension.IReplace(this, lModel){
                    final /* synthetic */ CharPairCloser this$1;
                    private final /* synthetic */ CharPairLinkedModeModel val$lModel;
                    {
                        this.this$1 = charPairCloser;
                        this.val$lModel = charPairLinkedModeModel;
                    }

                    public void perform(IDocument document, IDocumentListener owner) {
                        if (this.val$lModel.start.isDeleted()) {
                            try {
                                CharPairCloser.access$0(this.this$1).replace(this.val$lModel.end.offset, this.val$lModel.end.length, null);
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel model) {
        }

        public void resume(LinkedModeModel model, int flags) {
        }

        static /* synthetic */ IDocument access$0(CharPairCloser charPairCloser) {
            return charPairCloser.fDocument;
        }
    }
}

