/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.editors.JsEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenedFilesProposals {
    private Pattern functions = Pattern.compile("function\\s+([\\w\\.]+)\\s*\\(([^)]*)\\)");
    private Pattern backfunction = Pattern.compile("\\s*([\\w\\.]+)\\s*=\\s*function\\s*\\(([^)]*)\\)");
    private Map openedFiles = new HashMap();
    private List filesFunctions = new ArrayList();
    private static OpenedFilesProposals instance = new OpenedFilesProposals();

    private OpenedFilesProposals() {
    }

    public static OpenedFilesProposals getInstance() {
        return instance;
    }

    public List getCompletionsFor(String toComplete, boolean ignoreCase) {
        this.parseOpenedFiles();
        String toCheck = toComplete.replaceAll("\\\\", "");
        ArrayList<String[]> completions = new ArrayList<String[]>();
        HashMap<String, String> test = new HashMap<String, String>();
        Iterator it = this.filesFunctions.iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            Iterator itin = list.iterator();
            while (itin.hasNext()) {
                String[] func = (String[])itin.next();
                boolean toadd = ignoreCase ? func[0].toLowerCase().startsWith(toCheck.toLowerCase()) : func[0].startsWith(toCheck);
                if (!toadd || test.containsKey(func[0])) continue;
                completions.add(func);
                test.put(func[0], "");
            }
        }
        return completions;
    }

    private void parseOpenedFiles() {
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dwindow.getActivePage();
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            if (editors[i].getId().equals(JsEditor.ID)) {
                List funcs;
                Long time;
                FileEditorInput fei;
                IFile file;
                long modif;
                String name = editors[i].getName();
                JsEditor editor = (JsEditor)editors[i].getEditor(false);
                if (editor != null && (modif = (file = (fei = (FileEditorInput)editor.getEditorInput()).getFile()).getModificationStamp()) != -1L && ((time = (Long)this.openedFiles.get(name)) == null || time != modif) && (funcs = this.parseFile(file)) != null) {
                    this.openedFiles.put(name, new Long(modif));
                    this.filesFunctions.add(funcs);
                }
            }
            ++i;
        }
    }

    private List parseFile(IFile file) {
        String[] function;
        ArrayList<String[]> fun = new ArrayList<String[]>();
        if (!file.exists()) {
            return null;
        }
        String text = FileTools.getFileText(file);
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        Matcher m = this.functions.matcher(text);
        while (m.find()) {
            function = new String[]{m.group(1), m.group(2)};
            fun.add(function);
        }
        m = this.backfunction.matcher(text);
        while (m.find()) {
            function = new String[]{m.group(1), m.group(2)};
            fun.add(function);
        }
        return fun;
    }
}

