/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors;

import com.interaktonline.jseclipse.Messages;
import com.interaktonline.jseclipse.actions.ToggleMarkOccurrences;
import com.interaktonline.jseclipse.actions.WordWrapAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TextActionEditorContributor
extends BasicTextEditorActionContributor {
    public static final String CATEGORY_WORDWRAP = "WordWrap.";
    public static final String CATEGORY_TOGGLE_MARK_OCCURRENCES = "OccurrenceAnnotation.";
    private static final int STATUS_WIDTH = 15;
    private StatusLineContributionItem wordWrapContribution;
    private IEditorPart fActiveEditorPart;
    protected TextEditorAction fWordWrap = new WordWrapAction(Messages.getBundle(), "WordWrap.");
    protected TextEditorAction fToggleMarkOccurrences = new ToggleMarkOccurrences(Messages.getBundle(), "OccurrenceAnnotation.");

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("com.interaktonline.jseclipse.edit.toggleMarkOccurrences", (IAction)this.fToggleMarkOccurrences);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        this.wordWrapContribution = new StatusLineContributionItem(CATEGORY_WORDWRAP, true, 15);
        statusLineManager.add((IContributionItem)this.wordWrapContribution);
    }

    public void contributeToMenu(IMenuManager menu) {
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IAction)this.fWordWrap);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        ITextEditor editor;
        super.setActiveEditor(part);
        if (this.fActiveEditorPart == part) {
            return;
        }
        if (this.fActiveEditorPart instanceof ITextEditorExtension) {
            ITextEditorExtension extension = (ITextEditorExtension)this.fActiveEditorPart;
            extension.setStatusField(null, CATEGORY_WORDWRAP);
        }
        this.fActiveEditorPart = part;
        ITextEditor iTextEditor = editor = part instanceof ITextEditor ? (ITextEditor)part : null;
        if (editor != null) {
            this.fWordWrap.setEditor(editor);
            this.fToggleMarkOccurrences.setEditor(editor);
        }
        if (part instanceof ITextEditorExtension) {
            this.wordWrapContribution.setActionHandler(this.getAction(editor, "com.interaktonline.jseclipse.toggleWordwrap"));
            ITextEditorExtension extension = (ITextEditorExtension)part;
            extension.setStatusField((IStatusField)this.wordWrapContribution, CATEGORY_WORDWRAP);
        }
    }
}

