/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors.externals;

import com.interaktonline.jseclipse.editors.JsEditor;
import com.interaktonline.jseclipse.editors.externals.ExternalManagementEvent;
import com.interaktonline.jseclipse.editors.externals.ExternalsManager;
import com.interaktonline.jseclipse.editors.externals.IExternalManagementListener;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class ExternalEditor
implements IExternalManagementListener {
    private int offset;
    private int length;
    private AbstractDecoratedTextEditor original;
    private IDocument originalDocument;
    private IDocument newDocument;
    private IWorkbenchPartSite site;
    private String tempFilename;
    private String filename;

    public IDocument getNewDocument() {
        return this.newDocument;
    }

    public void setNewDocument(IDocument newDocument) {
        this.newDocument = newDocument;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    public void setSite(IWorkbenchPartSite site) {
        this.site = site;
    }

    public String getTempFilename() {
        return this.tempFilename;
    }

    public void setTempFilename(String tempFilename) {
        this.tempFilename = tempFilename;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public AbstractDecoratedTextEditor getOriginal() {
        return this.original;
    }

    public void setOriginal(AbstractDecoratedTextEditor original) {
        this.original = original;
    }

    public IDocument getOriginalDocument() {
        return this.originalDocument;
    }

    public void setOriginalDocument(IDocument originalDocument) {
        this.originalDocument = originalDocument;
    }

    public void isSaving(ExternalManagementEvent event) {
        JsEditor editor = (JsEditor)((Object)event.getSource());
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String content = doc.get();
        try {
            this.getSite().getPage().activate((IWorkbenchPart)this.original);
            this.originalDocument.replace(this.offset, this.length, content);
            this.length = content.length();
            this.getSite().getPage().activate((IWorkbenchPart)editor);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void isClosing(ExternalManagementEvent event) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFileForLocation((IPath)new Path(this.tempFilename));
        try {
            file.delete(true, false, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            File f = new File(this.tempFilename);
            f.delete();
        }
        ExternalsManager.getInstance().removeEditor(this);
    }
}

