/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors.externals;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.editors.JsEditor;
import com.interaktonline.jseclipse.editors.externals.ExternalEditor;
import com.interaktonline.jseclipse.ui.part.TempFileEditorInput;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class ExternalsManager {
    private static ExternalsManager instance = new ExternalsManager();
    private Map editors = new HashMap();

    private ExternalsManager() {
    }

    public static ExternalsManager getInstance() {
        return instance;
    }

    public void removeEditor(ExternalEditor ee) {
        this.editors.remove(ee.getFilename());
    }

    public void openSelectedRegion(AbstractDecoratedTextEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String text = doc.get();
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        int length = selection.getLength();
        int caretAt = -1;
        if (length == 0) {
            caretAt = offset;
            int[] span = this.getMaxScriptSpan(text, offset);
            if (span == null) {
                return;
            }
            offset = span[0];
            caretAt -= offset;
            length = span[1] - span[0];
        }
        String content = null;
        try {
            content = doc.get(offset, length);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return;
        }
        IEditorInput iei = editor.getEditorInput();
        if (!(iei instanceof FileEditorInput)) {
            return;
        }
        FileEditorInput fei = (FileEditorInput)iei;
        String oldfile = fei.getFile().getLocation().toOSString();
        ExternalEditor ee = (ExternalEditor)this.editors.get(oldfile);
        if (ee == null) {
            JsEditor jseditor;
            String newfile = this.getTempFilename(oldfile);
            FileTools.saveToFile(newfile, content);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFileForLocation((IPath)new Path(newfile));
            IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            try {
                TextEditor neweditor = (TextEditor)page.openEditor((IEditorInput)new TempFileEditorInput(file), "com.interaktonline.jseclipse.editors.JsEditor");
                jseditor = (JsEditor)neweditor;
                jseditor.setExternal(true);
                if (caretAt != -1) {
                    jseditor.setCarretOffset(caretAt);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
                return;
            }
            IDocument newdoc = jseditor.getDocumentProvider().getDocument((Object)jseditor.getEditorInput());
            ee = new ExternalEditor();
            ee.setOriginal(editor);
            ee.setOriginalDocument(doc);
            ee.setNewDocument(newdoc);
            ee.setTempFilename(newfile);
            ee.setSite(editor.getSite());
            ee.setFilename(oldfile);
            this.editors.put(oldfile, ee);
            jseditor.addExternalManagementListener(ee);
        } else {
            IDocument newdoc = ee.getNewDocument();
            try {
                newdoc.replace(0, newdoc.getLength(), content);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        ee.setOffset(offset);
        ee.setLength(length);
    }

    /*
     * Unable to fully structure code
     */
    private int[] getMaxScriptSpan(String text, int offset) {
        span = new int[2];
        low = text.toLowerCase();
        firstEnd = low.indexOf("</script>", offset);
        if (firstEnd == -1) {
            return null;
        }
        aStart = low.indexOf("<script>", offset);
        if (aStart != -1 && firstEnd > aStart) {
            return null;
        }
        firstStart = low.lastIndexOf("<script", offset);
        if (firstStart != -1) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            ++firstStart;
lbl13:
            // 2 sources

            ** while (text.charAt((int)firstStart) != '>')
        }
lbl14:
        // 1 sources

        span[0] = firstStart + 1;
        span[1] = firstEnd;
        return span;
    }

    private String getTempFilename(String baseFilename) {
        File base = new File(baseFilename);
        try {
            File tmp = File.createTempFile("temp", ".js", base.getParentFile());
            return tmp.getPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return String.valueOf(baseFilename) + "_JSE.js";
        }
    }
}

