/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.editors.formatter;

import com.interaktonline.jseclipse.text.CodeFormatter;
import java.util.LinkedList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JSDocumentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private CodeFormatter fCodeFormatter = new CodeFormatter();

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            try {
                TextEdit edit = this.fCodeFormatter.format2(document.get(), partition.getOffset(), partition.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document), this.getPreferences());
                if (edit != null) {
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

