/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.embed;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.text.JsMarkersFactory;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.debug.DebuggableScript;

public class JsContext {
    private Context cx;
    private Script script;
    protected IPreferenceStore store = JavaScriptEditorPlugin.getDefault().getPreferenceStore();
    protected ScriptOrFnNode tree;
    protected DebuggableScript dbg;
    private static JsContext instance = new JsContext();
    private JsMarkersFactory markersFactory = JsMarkersFactory.getInstance();
    CompilerEnvirons compilerEnv;

    private JsContext() {
    }

    public static JsContext getInstance() {
        return instance;
    }

    public ScriptOrFnNode getParsingTree() {
        return this.tree;
    }

    public Script getScript() {
        return this.script;
    }

    public DebuggableScript getDebuggableScript() {
        return this.dbg;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String eval(String sourceString, boolean reportErrors) {
        String error = null;
        if (reportErrors) {
            this.markersFactory.deleteProblems();
        }
        this.cx = Context.enter();
        this.compilerEnv = new CompilerEnvirons();
        this.compilerEnv.initFromContext(this.cx);
        JsErrorReporter errorReporter = reportErrors ? new JsErrorReporter() : this.compilerEnv.getErrorReporter();
        Parser p = new Parser(this.compilerEnv, (ErrorReporter)errorReporter);
        p.setFailOnFirstError(false);
        this.tree = null;
        try {
            try {
                this.tree = p.parse(sourceString, "", 1);
            }
            catch (Exception e) {
                error = e.getMessage();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        Context.exit();
        return error;
    }

    private class JsErrorReporter
    implements ErrorReporter {
        private JsErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (!this.validMessage(message)) {
                return;
            }
            this.addMarker(message, line, 1);
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (!this.validMessage(message)) {
                return;
            }
            if (lineSource.trim().equals("debugger;")) {
                this.addBreakpoint("Line breakpoint: " + JsContext.this.markersFactory.getResourceName() + " [line: " + line + "]", line, 0);
            } else {
                this.addMarker(message, line, 2);
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.addMarker(message, line, 2);
            return null;
        }

        private void addBreakpoint(String message, int line, int severity) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", message);
            attributes.put("lineNumber", new Integer(line));
            JsContext.this.markersFactory.createMarker(attributes, JsMarkersFactory.BREAKPOINT);
        }

        private void addMarker(String message, int line, int severity) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", message);
            attributes.put("lineNumber", new Integer(line));
            attributes.put("severity", new Integer(severity));
            JsContext.this.markersFactory.createMarker(attributes, "org.eclipse.core.resources.problemmarker");
        }

        private boolean validMessage(String message) {
            IMarker[] m = JsContext.this.markersFactory.getMarkers("org.eclipse.core.resources.problemmarker");
            if (m == null || m.length == 0) {
                return true;
            }
            return !message.trim().equals("syntax error");
        }
    }
}

