/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.jsdom;

import com.interaktonline.jseclipse.jsdom.Comment;
import com.interaktonline.jseclipse.jsdom.Error;
import com.interaktonline.jseclipse.jsdom.Function;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.jsdom.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.Position;

public class JsDocNode
extends JsNode {
    private Map positions = new HashMap();

    public JsDocNode(String text, Position position) {
        super(null, text, position);
    }

    public JsNode createNode(String aText, Position p) {
        Assert.isNotNull((Object)p);
        JsNode node = new JsNode(this, aText, p);
        this.positions.put(p, node);
        return node;
    }

    public Comment createComment(String aText, Position p) {
        Assert.isNotNull((Object)p);
        Comment node = new Comment(this, aText, p);
        this.positions.put(p, node);
        return node;
    }

    public Function createFunction(String aText, Position p) {
        Assert.isNotNull((Object)p);
        Function node = new Function(this, aText, p);
        this.positions.put(p, node);
        return node;
    }

    public Variable createVariable(String aText, Position p) {
        Assert.isNotNull((Object)p);
        Variable node = new Variable(this, aText, p);
        this.positions.put(p, node);
        return node;
    }

    public Error createError(String aText, Position p) {
        return new Error(this, aText, p);
    }

    public JsNode getNodeByPosition(Position p) {
        return (JsNode)this.positions.get(p);
    }

    public JsNode getNodeByPositionStart(Position p) {
        HashMap positionsClone = (HashMap)((HashMap)this.positions).clone();
        Set keys = positionsClone.keySet();
        Position key = null;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Position element = (Position)iter.next();
            if (element.offset != p.offset) continue;
            key = element;
            break;
        }
        if (key != null) {
            return (JsNode)positionsClone.get(key);
        }
        return null;
    }

    public boolean aproximateEquals(JsNode node) {
        return node instanceof JsDocNode;
    }

    public Position[] getOverlappingPositions(int offset, int length) {
        ArrayList<Position> list = new ArrayList<Position>();
        Iterator it = this.positions.keySet().iterator();
        while (it.hasNext()) {
            Position p = (Position)it.next();
            if (!p.overlapsWith(offset, length)) continue;
            list.add(p);
        }
        return list.toArray(new Position[0]);
    }

    public void sortByPosition() {
        Object[] kids = this.children.toArray();
        Arrays.sort(kids, new PositionComparator());
        this.children.clear();
        int i = 0;
        while (i < kids.length) {
            this.children.add(kids[i]);
            ++i;
        }
    }

    public void moveConstructorsToClasses() {
        ArrayList<JsNode> toRemove = new ArrayList<JsNode>();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            JsNode classNode;
            String methodName;
            int ix;
            JsNode node = (JsNode)it.next();
            if (node.getType() != JsNode.FUNCTION || (ix = (methodName = node.getText()).indexOf(40)) == -1 || (classNode = (JsNode)this.classes.get(methodName.substring(0, ix))) == null) continue;
            classNode.addChild(node);
            toRemove.add(node);
            classNode.setOffset(node.getOffset());
        }
        this.children.removeAll(toRemove);
    }

    private class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Error) {
                return -1;
            }
            if (arg1 instanceof Error) {
                return 1;
            }
            JsNode a = (JsNode)arg0;
            JsNode b = (JsNode)arg1;
            return a.getOffset() - b.getOffset();
        }
    }
}

