/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.jsdom;

import com.interaktonline.jseclipse.jsdom.JsDocNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Image;

public class JsNode {
    public static int M_STATIC = 1;
    public static int M_PRIVATE = 2;
    private int modifiers = 0;
    public static int CLASS = 1;
    public static int NAMESPACE = 2;
    public static int THIS = 3;
    public static int VARIABLE = 4;
    public static int FUNCTION = 5;
    public static int METHOD = 6;
    public static int COMMENT = 7;
    protected String text;
    protected Image image;
    protected int type;
    protected Position fPosition;
    protected int lineno;
    protected JsNode parent = null;
    protected JsDocNode document;
    protected ArrayList children;
    protected Map classes;
    protected Map variables;
    protected String extendsString = "";
    private String doc;

    JsNode(JsDocNode owner, String text, Position p) {
        this.text = text;
        this.fPosition = p;
        this.children = new ArrayList();
        this.document = owner;
        this.classes = new HashMap();
        this.variables = new HashMap();
    }

    private JsNode() {
    }

    public String getExtendsString() {
        return this.extendsString;
    }

    public void setExtendsString(String extendsString) {
        this.extendsString = extendsString;
    }

    public JsNode[] getClassNodes() {
        JsNode[] classNodes = new JsNode[this.classes.size()];
        int i = 0;
        Iterator it = this.classes.values().iterator();
        while (it.hasNext()) {
            classNodes[i++] = (JsNode)it.next();
        }
        return classNodes;
    }

    public JsNode[] getVarNodes() {
        JsNode[] varNodes = new JsNode[this.variables.size()];
        int i = 0;
        Iterator it = this.variables.values().iterator();
        while (it.hasNext()) {
            varNodes[i++] = (JsNode)it.next();
        }
        return varNodes;
    }

    public JsNode getVarNode(String varName) {
        return (JsNode)this.variables.get(varName);
    }

    public void addVarNode(JsNode varNode) {
        this.variables.put(varNode.getText(), varNode);
        this.addChild(varNode);
    }

    public void addOrReplaceVarNode(JsNode varNode, boolean replace) {
        JsNode newVar = null;
        newVar = this.getVarNode(varNode.getText());
        if (newVar != null) {
            if (replace) {
                this.variables.remove(varNode.getText());
                this.removeChild(newVar);
                this.addVarNode(varNode);
            }
        } else {
            this.addVarNode(varNode);
        }
    }

    public JsNode getClassNode(String className) {
        return (JsNode)this.classes.get(className);
    }

    public void addClassNode(JsNode classNode) {
        JsNode cn = this.getClassNode(classNode.getText());
        if (cn == null) {
            this.classes.put(classNode.getText(), classNode);
            this.addChild(classNode);
        } else {
            cn.mergeClass(classNode);
        }
    }

    public void mergeClass(JsNode source) {
        String ext = source.getExtendsString();
        if (ext != null && ext.trim().length() != 0) {
            this.setExtendsString(source.getExtendsString());
        }
        this.addAll(source.getChildNodes());
    }

    public boolean hasChildrenExcluding(int[] filter) {
        ArrayList kids = this.getChildNodesNotIn(filter);
        return kids.size() != 0;
    }

    public void addChild(JsNode node) {
        this.children.add(node);
        node.setParent(this);
    }

    public void addChild(JsNode node, int ix) {
        this.children.add(ix, node);
        node.setParent(this);
    }

    public void addAll(List kids) {
        int i = 0;
        while (i < kids.size()) {
            JsNode kid = (JsNode)kids.get(i);
            if (kid.getType() == CLASS) {
                this.addClassNode(kid);
            } else {
                this.addChild(kid);
            }
            ++i;
        }
    }

    public void removeChild(JsNode node) {
        this.children.remove(node);
        node.setParent(null);
    }

    public Object removeChild(int ix) {
        if (ix >= this.children.size()) {
            return null;
        }
        JsNode node = (JsNode)this.children.remove(ix);
        node.setParent(null);
        return node;
    }

    public void setChildNodes(ArrayList kids) {
        this.children = kids;
    }

    public JsNode getChildNode(int i) {
        return (JsNode)this.children.get(i);
    }

    public JsNode getChildNode(String text) {
        int i = 0;
        while (i < this.children.size()) {
            JsNode kid = (JsNode)this.children.get(i);
            if (kid.getText().equals(text)) {
                return kid;
            }
            JsNode ret = kid.getChildNode(text);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public ArrayList getChildNodes() {
        return this.children;
    }

    public ArrayList getChildNodesNotIn(int[] filter) {
        if (filter == null || filter.length == 0) {
            return this.children;
        }
        Arrays.sort(filter);
        ArrayList<JsNode> kids = new ArrayList<JsNode>();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            JsNode kid = (JsNode)it.next();
            if (Arrays.binarySearch(filter, kid.getType()) >= 0) continue;
            kids.add(kid);
        }
        return kids;
    }

    public ArrayList getChildNodesIn(int[] filter) {
        if (filter == null || filter.length == 0) {
            return this.children;
        }
        Arrays.sort(filter);
        ArrayList<JsNode> kids = new ArrayList<JsNode>();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            JsNode kid = (JsNode)it.next();
            if (Arrays.binarySearch(filter, kid.getType()) < 0) continue;
            kids.add(kid);
        }
        return kids;
    }

    public List getAproximateMatch(List nodes) {
        ArrayList<JsNode> matches = new ArrayList<JsNode>();
        Object rem = null;
        int i = 0;
        while (i < nodes.size()) {
            if (this.aproximateEquals((JsNode)nodes.get(i))) {
                matches.add(this);
                rem = nodes.get(i);
                break;
            }
            ++i;
        }
        if (rem != null) {
            nodes.remove(rem);
        }
        if (nodes.size() > 0) {
            i = 0;
            while (i < this.children.size()) {
                JsNode kid = (JsNode)this.children.get(i);
                matches.addAll(kid.getAproximateMatch(nodes));
                ++i;
            }
        }
        return matches;
    }

    public boolean aproximateEquals(JsNode node) {
        if (this.type != node.getType()) {
            return false;
        }
        if (!this.parent.aproximateEquals(node.parent)) {
            return false;
        }
        return this.text.equals(node.getText()) || this.getOffset() == node.getOffset();
    }

    public void replace(JsNode oldNode, JsNode newNode) {
        int ix = this.children.indexOf(oldNode);
        this.children.remove(ix);
        this.children.add(ix, newNode);
    }

    public int getTextLength() {
        return this.text.length();
    }

    public int getOffset() {
        return this.fPosition.getOffset();
    }

    public void setOffset(int offset) {
        this.fPosition.setOffset(offset);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        if (this.type == CLASS && this.extendsString != null && this.extendsString.trim().length() != 0) {
            return String.valueOf(this.text) + " <" + this.extendsString + "> ";
        }
        return this.text;
    }

    public JsNode getParent() {
        return this.parent;
    }

    public void setParent(JsNode parent) {
        this.parent = parent;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setLength(int length) {
        this.fPosition.setLength(length);
    }

    public int getLength() {
        return this.fPosition.getLength();
    }

    public Position getPosition() {
        return this.fPosition;
    }

    public void setPosition(Position position) {
        this.fPosition = position;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setLineno(int lineno) {
        this.lineno = lineno;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void addModifier(int modifier) {
        this.modifiers |= modifier;
    }

    public void removeModifier(int modifier) {
        this.modifiers ^= modifier;
    }

    public boolean hasModifier(int modifier) {
        return (this.modifiers & modifier) == modifier;
    }

    public static class TextComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            JsNode a0 = (JsNode)arg0;
            JsNode a1 = (JsNode)arg1;
            return a0.getText().compareTo(a1.getText());
        }
    }
}

